/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.enchantment;

import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class FilterAvailableEnchantmentsEventJS
extends EventJS {
    private final List<EnchantmentInstance> enchantments;
    private final int powerLevel;
    private final ItemStack item;

    public FilterAvailableEnchantmentsEventJS(List<EnchantmentInstance> enchantments, int powerLevel, ItemStack item) {
        this.enchantments = enchantments;
        this.powerLevel = powerLevel;
        this.item = item;
    }

    public void printEnchantmentInstances() {
        this.enchantments.stream().sorted((ei1, ei2) -> {
            ResourceLocation key1 = BuiltInRegistries.f_256876_.m_7981_((Object)ei1.f_44947_);
            ResourceLocation key2 = BuiltInRegistries.f_256876_.m_7981_((Object)ei2.f_44947_);
            assert (key1 != null);
            assert (key2 != null);
            int c = key1.toString().compareTo(key2.toString());
            if (c != 0) {
                return c;
            }
            return Integer.compare(ei1.f_44948_, ei2.f_44948_);
        }).forEach(ei -> ConsoleJS.SERVER.info((Object)(String.valueOf(BuiltInRegistries.f_256876_.m_7981_((Object)ei.f_44947_)) + " (Level: " + ei.f_44948_ + ")")));
    }

    public List<EnchantmentInstance> getEnchantmentInstances() {
        return this.enchantments;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public void addWithLevel(Enchantment enchantment, int level) {
        this.enchantments.add(new EnchantmentInstance(enchantment, level));
    }

    public void add(Enchantment ... enchantments) {
        int pl = this.getPowerLevel();
        block0: for (Enchantment enchantment : enchantments) {
            for (int el = enchantment.m_6586_(); el > enchantment.m_44702_() - 1; --el) {
                if (enchantment.m_6183_(el) > pl || pl > enchantment.m_6175_(el)) continue;
                this.enchantments.add(new EnchantmentInstance(enchantment, el));
                continue block0;
            }
        }
    }

    public void remove(Enchantment ... enchantments) {
        Set<Enchantment> filter = Set.of(enchantments);
        this.enchantments.removeIf(ei -> filter.contains(ei.f_44947_));
    }
}

