/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.registry;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.level.entity.SpawnPlacementsRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import tech.alexnijjar.golemoverhaul.common.entities.golems.BarrelGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CandleGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CoalGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HoneyGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.KelpGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.NetheriteGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.SlimeGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.TerracottaGolem;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.CandleFlameProjectile;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.HoneyBlobProjectile;
import tech.alexnijjar.golemoverhaul.common.entities.projectiles.MudBallProjectile;
import tech.alexnijjar.golemoverhaul.common.registry.forge.ModEntityTypesImpl;
import tech.alexnijjar.golemoverhaul.common.tags.ModBiomeTags;

public class ModEntityTypes {
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create((Registry)BuiltInRegistries.f_256780_, (String)"golemoverhaul");
    public static final ResourcefulRegistry<EntityType<?>> GOLEMS = ResourcefulRegistries.create(ENTITY_TYPES);
    public static final ResourcefulRegistry<EntityType<?>> PROJECTILES = ResourcefulRegistries.create(ENTITY_TYPES);
    public static final RegistryEntry<EntityType<BarrelGolem>> BARREL_GOLEM = GOLEMS.register("barrel_golem", () -> ModEntityTypes.createEntityBuilder(BarrelGolem::new, MobCategory.CREATURE).sized(1.0f, 1.0f).clientTrackingRange(10).build("barrel_golem"));
    public static final RegistryEntry<EntityType<CandleGolem>> CANDLE_GOLEM = GOLEMS.register("candle_golem", () -> ModEntityTypes.createEntityBuilder(CandleGolem::new, MobCategory.CREATURE).sized(0.375f, 0.5625f).clientTrackingRange(10).build("candle_golem"));
    public static final RegistryEntry<EntityType<CoalGolem>> COAL_GOLEM = GOLEMS.register("coal_golem", () -> ModEntityTypes.createEntityBuilder(CoalGolem::new, MobCategory.AMBIENT).sized(0.25f, 0.5f).clientTrackingRange(10).fireImmune().build("coal_golem"));
    public static final RegistryEntry<EntityType<HayGolem>> HAY_GOLEM = GOLEMS.register("hay_golem", () -> ModEntityTypes.createEntityBuilder(HayGolem::new, MobCategory.CREATURE).sized(0.75f, 2.0f).clientTrackingRange(10).build("hay_golem"));
    public static final RegistryEntry<EntityType<HoneyGolem>> HONEY_GOLEM = GOLEMS.register("honey_golem", () -> ModEntityTypes.createEntityBuilder(HoneyGolem::new, MobCategory.CREATURE).sized(0.875f, 1.0f).clientTrackingRange(10).build("honey_golem"));
    public static final RegistryEntry<EntityType<KelpGolem>> KELP_GOLEM = GOLEMS.register("kelp_golem", () -> ModEntityTypes.createEntityBuilder(KelpGolem::new, MobCategory.CREATURE).sized(0.8125f, 1.25f).clientTrackingRange(10).build("kelp_golem"));
    public static final RegistryEntry<EntityType<NetheriteGolem>> NETHERITE_GOLEM = GOLEMS.register("netherite_golem", () -> ModEntityTypes.createEntityBuilder(NetheriteGolem::new, MobCategory.CREATURE).sized(1.75f, 2.1f).clientTrackingRange(10).fireImmune().build("netherite_golem"));
    public static final RegistryEntry<EntityType<SlimeGolem>> SLIME_GOLEM = GOLEMS.register("slime_golem", () -> ModEntityTypes.createEntityBuilder(SlimeGolem::new, MobCategory.MONSTER).sized(1.125f, 0.8125f).clientTrackingRange(10).build("slime_golem"));
    public static final RegistryEntry<EntityType<TerracottaGolem>> TERRACOTTA_GOLEM = GOLEMS.register("terracotta_golem", () -> ModEntityTypes.createEntityBuilder(TerracottaGolem::new, MobCategory.CREATURE).sized(0.5f, 0.75f).clientTrackingRange(10).build("terracotta_golem"));
    public static final RegistryEntry<EntityType<CandleFlameProjectile>> CANDLE_FLAME = PROJECTILES.register("candle_flame", () -> ModEntityTypes.createEntityBuilder(CandleFlameProjectile::new, MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("candle_flame"));
    public static final RegistryEntry<EntityType<MudBallProjectile>> MUD_BALL = PROJECTILES.register("mud_ball", () -> ModEntityTypes.createEntityBuilder(MudBallProjectile::new, MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("mud_ball"));
    public static final RegistryEntry<EntityType<HoneyBlobProjectile>> HONEY_BLOB = PROJECTILES.register("honey_blob", () -> ModEntityTypes.createEntityBuilder(HoneyBlobProjectile::new, MobCategory.MISC).sized(0.25f, 0.25f).clientTrackingRange(4).updateInterval(10).build("honey_blob"));

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> PlatformEntityBuilder<T> createEntityBuilder(EntityType.EntityFactory<T> factory, MobCategory category) {
        void var1_1;
        return ModEntityTypesImpl.createEntityBuilder(factory, (MobCategory)var1_1);
    }

    public static void init() {
        ENTITY_TYPES.init();
        ModEntityTypes.registerAttributes();
        ModEntityTypes.registerSpawnPlacements();
        ModEntityTypes.registerBiomeModifications();
    }

    private static void registerAttributes() {
        EntityAttributeRegistry.register(BARREL_GOLEM, BarrelGolem::createAttributes);
        EntityAttributeRegistry.register(CANDLE_GOLEM, CandleGolem::createAttributes);
        EntityAttributeRegistry.register(COAL_GOLEM, CoalGolem::createAttributes);
        EntityAttributeRegistry.register(HAY_GOLEM, HayGolem::createAttributes);
        EntityAttributeRegistry.register(HONEY_GOLEM, HoneyGolem::createAttributes);
        EntityAttributeRegistry.register(KELP_GOLEM, KelpGolem::createAttributes);
        EntityAttributeRegistry.register(NETHERITE_GOLEM, NetheriteGolem::createAttributes);
        EntityAttributeRegistry.register(SLIME_GOLEM, SlimeGolem::createAttributes);
        EntityAttributeRegistry.register(TERRACOTTA_GOLEM, TerracottaGolem::createAttributes);
    }

    private static void registerSpawnPlacements() {
        SpawnPlacementsRegistry.register(BARREL_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BarrelGolem::checkMobSpawnRules);
        SpawnPlacementsRegistry.register(CANDLE_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        SpawnPlacementsRegistry.register(COAL_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CoalGolem::checkMobSpawnRules);
        SpawnPlacementsRegistry.register(HAY_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HayGolem::checkMobSpawnRules);
        SpawnPlacementsRegistry.register(HONEY_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HoneyGolem::checkMobSpawnRules);
        SpawnPlacementsRegistry.register(KELP_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        SpawnPlacementsRegistry.register(NETHERITE_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_);
        SpawnPlacementsRegistry.register(SLIME_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SlimeGolem::checkSlimeSpawnRules);
        SpawnPlacementsRegistry.register(TERRACOTTA_GOLEM, (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, TerracottaGolem::checkMobSpawnRules);
    }

    private static void registerBiomeModifications() {
        ModEntityTypes.addSpawn(COAL_GOLEM, ModBiomeTags.COAL_GOLEM_SPAWNS, 20, 3, 5);
        ModEntityTypes.addSpawn(HONEY_GOLEM, ModBiomeTags.HONEY_GOLEM_SPAWNS, 6, 1, 2);
        ModEntityTypes.addSpawn(SLIME_GOLEM, ModBiomeTags.SLIME_GOLEM_SPAWNS, 25, 1, 2);
        ModEntityTypes.addSpawn(SLIME_GOLEM, ModBiomeTags.SLIME_GOLEM_SWAMP_SPAWNS, 1, 1, 1);
        ModEntityTypes.addSpawn(TERRACOTTA_GOLEM, ModBiomeTags.TERRACOTTA_GOLEM_SPAWNS, 6, 1, 2);
    }

    private static <T extends Entity> void addSpawn(RegistryEntry<EntityType<T>> entityType, TagKey<Biome> spawnBiomesTag, int weight, int minCount, int maxCount) {
        BiomeModifications.addProperties(biomeContext -> biomeContext.hasTag(spawnBiomesTag), (context, properties) -> properties.getSpawnProperties().addSpawn(((EntityType)entityType.get()).m_20674_(), new MobSpawnSettings.SpawnerData((EntityType)entityType.get(), weight, minCount, maxCount)));
    }

    public static interface PlatformEntityBuilder<T extends Entity> {
        public PlatformEntityBuilder<T> sized(float var1, float var2);

        public PlatformEntityBuilder<T> clientTrackingRange(int var1);

        public PlatformEntityBuilder<T> updateInterval(int var1);

        public PlatformEntityBuilder<T> fireImmune();

        public EntityType<T> build(String var1);
    }
}

