/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.IShearable;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CoalGolem;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;
import tech.alexnijjar.golemoverhaul.common.recipes.SingleEntityInput;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModRecipeTypes;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class NetheriteGolem
extends BaseGolem
implements IShearable,
PlayerRideableJumping {
    public static final byte SUMMON_EVENT_ID = 8;
    public static final int SUMMON_TICKS_LENGTH = 60;
    public static final int DEATH_TICKS = 50;
    public static final int SUMMONING_COOLDOWN_TICKS_LENGTH = 1200;
    private static final EntityDataAccessor<Boolean> ID_CHARGED = SynchedEntityData.m_135353_(NetheriteGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ID_GILDED = SynchedEntityData.m_135353_(NetheriteGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int summoningTicks;
    private int summonCooldown;
    private int lastJumpPower;

    public NetheriteGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 24;
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_274367_(this.m_274421_() + 0.5f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 320.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22279_, 0.14).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22281_, 20.0);
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        GolemConstructionRecipe recipe = (GolemConstructionRecipe)level.m_7465_().m_44015_((RecipeType)ModRecipeTypes.GOLEM_CONSTRUCTION.get(), (Container)new SingleEntityInput((EntityType)ModEntityTypes.NETHERITE_GOLEM.get()), level).orElseThrow();
        BlockPattern.BlockPatternMatch pattern = recipe.createPattern().m_61184_((LevelReader)level, pos);
        if (pattern == null) {
            return;
        }
        NetheriteGolem golem = (NetheriteGolem)((EntityType)ModEntityTypes.NETHERITE_GOLEM.get()).m_20615_(level);
        if (golem == null) {
            return;
        }
        ModUtils.spawnGolemInWorld(level, pattern, (Entity)golem, pattern.m_61229_(1, 2, 0).m_61176_());
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.getMovementController()});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attack_controller", 0, state -> {
            if (!this.hasAttackAnimation()) {
                return PlayState.STOP;
            }
            if (this.attackAnimationTicks == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return this.getAttackAnimation((AnimationState<? extends BaseGolem>)state);
        }).setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_HIT.get(), this.m_5720_(), 1.0f, 1.0f, false))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "death_controller", 0, state -> {
            if (this.f_20919_ == 0) {
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.DIE);
        }).setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_DEATH.get(), this.m_5720_(), 1.0f, 1.0f, false))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "summon_controller", 0, state -> {
            if (this.getSummoningTicks() == 0) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.SUMMON);
        }).setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_SUMMON.get(), this.m_5720_(), 1.0f, 1.0f, false))});
    }

    @Override
    public AnimationController<?> getMovementController() {
        return super.getMovementController().setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_STEP.get(), this.m_5720_(), 1.0f, 1.0f, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_CHARGED, (Object)false);
        this.f_19804_.m_135372_(ID_GILDED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("charged", this.isCharged());
        compound.m_128379_("gilded", this.isGilded());
        compound.m_128405_("summoning_ticks", this.getSummoningTicks());
        compound.m_128405_("summon_cooldown", this.getSummonCooldown());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCharged(compound.m_128471_("charged"));
        this.setGilded(compound.m_128471_("gilded"));
        this.setSummoningTicks(compound.m_128451_("summoning_ticks"));
        this.setSummonCooldown(compound.m_128451_("summon_cooldown"));
    }

    public boolean isCharged() {
        return (Boolean)this.f_19804_.m_135370_(ID_CHARGED);
    }

    public void setCharged(boolean charged) {
        this.f_19804_.m_135381_(ID_CHARGED, (Object)charged);
    }

    public boolean isGilded() {
        return (Boolean)this.f_19804_.m_135370_(ID_GILDED);
    }

    public void setGilded(boolean gilded) {
        this.f_19804_.m_135381_(ID_GILDED, (Object)gilded);
    }

    public int getSummoningTicks() {
        return this.summoningTicks;
    }

    public void setSummoningTicks(int summoningTicks) {
        this.summoningTicks = summoningTicks;
    }

    public int getSummonCooldown() {
        return this.summonCooldown;
    }

    public void setSummonCooldown(int summonCooldown) {
        this.summonCooldown = summonCooldown;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.NETHERITE_GOLEM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 8) {
            this.summoningTicks = 60;
        }
    }

    protected boolean m_6129_() {
        return false;
    }

    protected float m_6108_() {
        return 0.0f;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268585_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268530_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6126_() {
        return this.isCharged();
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return effectInstance.m_19544_().m_19486_();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 50 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.removeAndAddDeathParticles();
        }
    }

    @Override
    public boolean canFloatInWater() {
        return false;
    }

    @Override
    public boolean hasAttackAnimation() {
        return this.getSummoningTicks() == 0;
    }

    @Override
    public int getAttackTicks() {
        return 25;
    }

    @Override
    public int getAttackDelayTicks() {
        return 14;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42419_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 80.0f;
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (super.m_6071_(player, hand).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.isCharged()) {
            if (stack.m_150930_(Items.f_42446_)) {
                this.setCharged(false);
                return InteractionResult.SUCCESS;
            }
        } else if (stack.m_150930_(Items.f_42448_)) {
            if (!player.m_150110_().f_35937_) {
                player.m_21008_(hand, Items.f_42446_.m_7968_());
            }
            this.m_216990_(SoundEvents.f_11780_);
            this.setCharged(true);
            return InteractionResult.SUCCESS;
        }
        if (!this.isGilded() && stack.m_150930_(Items.f_42417_)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_216990_(SoundEvents.f_11676_);
            this.setGilded(true);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Items.f_42574_)) {
            return InteractionResult.PASS;
        }
        if (player.m_20202_() == null) {
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public List<ItemStack> onSheared() {
        this.m_216990_(SoundEvents.f_12480_);
        this.m_216990_(SoundEvents.f_11676_);
        this.setGilded(false);
        return List.of(Items.f_42417_.m_7968_());
    }

    @Override
    public boolean isShearable() {
        return this.isGilded();
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(1.0, 0.0, 1.0);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        if (passenger instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)passenger;
            entity.f_20883_ = this.f_20883_;
        }
    }

    protected void m_274498_(Player player, Vec3 travelVector) {
        super.m_274498_(player, travelVector);
        Vec2 vec2 = this.getRiddenRotation((LivingEntity)player);
        this.m_19915_(vec2.f_82471_, vec2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
    }

    protected Vec2 getRiddenRotation(LivingEntity entity) {
        return new Vec2(entity.m_146909_() * 0.5f, entity.m_146908_());
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        float x = player.f_20900_ * 0.25f;
        float z = player.f_20902_;
        if (z <= 0.0f) {
            z *= 0.25f;
        }
        return new Vec3((double)x, 0.0, (double)z);
    }

    protected float m_245547_(Player player) {
        if (this.getSummoningTicks() > 0) {
            return 0.0f;
        }
        return (float)this.m_21133_(Attributes.f_22279_) * 0.45f;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_21525_() && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            return entity2;
        }
        return null;
    }

    public void m_7888_(int jumpPower) {
    }

    public boolean m_7132_() {
        return !this.isAttacking();
    }

    public void m_7199_(int jumpPower) {
        this.startAttacking();
        this.sendAttackEvent();
        this.lastJumpPower = jumpPower;
    }

    public void m_8012_() {
    }

    @Override
    public void actuallyAttackAfterDelay(LivingEntity target) {
        if (this.lastJumpPower == 0) {
            Vec3 lookAngle = this.m_20154_();
            target.m_246865_(new Vec3(lookAngle.f_82479_ * 0.4, 0.5, lookAngle.f_82481_ * 0.4));
            super.actuallyAttackAfterDelay(target);
        }
    }

    @Override
    public void performAdditionalAttacks(@Nullable LivingEntity target) {
        if (this.lastJumpPower > 0) {
            int attackBonus = this.lastJumpPower;
            int rangeBonus = this.lastJumpPower;
            float y = 0.5f;
            if (this.lastJumpPower == 100) {
                attackBonus = 175;
                rangeBonus = 150;
                y = 0.75f;
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    Vec3 lookAngle = this.m_20154_();
                    ModUtils.sendParticles(level2, ParticleTypes.f_123813_, this.m_20185_() + lookAngle.f_82479_ * 0.5, this.m_20186_() + 0.5, this.m_20189_() + lookAngle.f_82481_ * 0.5, 10, 0.5, 0.5, 0.5, 0.0);
                }
            }
            this.doAoeAttack(null, 4.0f + (float)attackBonus / 6.0f, 1.5f + (float)rangeBonus / 40.0f, y);
            this.lastJumpPower = 0;
        } else {
            this.doAoeAttack(target, (float)this.m_21133_(Attributes.f_22281_), 0.5f, 0.5f);
        }
    }

    public void doAoeAttack(@Nullable LivingEntity target, float damage, float radius, float y) {
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)radius))) {
            if (entity == this || target != null && entity instanceof AbstractGolem || target != null && entity instanceof Player || target != null && entity instanceof OwnableEntity || entity.equals((Object)this.m_146895_())) continue;
            entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
            Vec3 lookAngle = this.m_20154_();
            entity.m_246865_(new Vec3(lookAngle.f_82479_ * 0.4, (double)y, lookAngle.f_82481_ * 0.4));
        }
    }

    public boolean m_6779_(LivingEntity target) {
        return !this.m_20160_() && super.m_6779_(target);
    }

    @Override
    public void m_8107_() {
        this.summoningTicks = Math.max(0, this.summoningTicks - 1);
        this.summonCooldown = Math.max(0, this.summonCooldown - 1);
        if (!this.m_9236_().m_5776_()) {
            if (this.summoningTicks > 0) {
                if (this.summoningTicks == 40) {
                    this.spawnCoalGolems();
                }
                this.f_21344_.m_26573_();
                this.m_6710_(null);
            }
            if (!this.isAttacking() && this.summonCooldown == 0 && this.m_5448_() != null && this.m_146895_() == null && this.f_19796_.m_188503_(100) == 0) {
                this.summon();
            }
        }
        if (this.m_9236_().m_5776_() && this.isCharged()) {
            this.spawnFireParticles();
        }
        super.m_8107_();
    }

    private void spawnFireParticles() {
        Vec3 lookAngle = this.m_20154_();
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.3) + lookAngle.f_82479_ * 0.5, this.m_20186_() + 0.8, this.m_20262_(0.3) + lookAngle.f_82481_ * 0.5, lookAngle.f_82479_ * 0.05, 0.05, lookAngle.f_82481_ * 0.05);
    }

    public void summon() {
        if (this.summonCooldown > 0) {
            return;
        }
        if (!this.isCharged()) {
            return;
        }
        this.summoningTicks = 60;
        this.summonCooldown = 1200;
        this.m_9236_().m_7605_((Entity)this, (byte)8);
    }

    public void spawnCoalGolems() {
        int i;
        this.m_216990_(SoundEvents.f_11874_);
        for (i = 0; i < 5; ++i) {
            CoalGolem golem = (CoalGolem)((EntityType)ModEntityTypes.COAL_GOLEM.get()).m_20615_(this.m_9236_());
            if (golem == null) {
                return;
            }
            Vec3 lookAngle = this.m_20154_();
            golem.m_6034_(this.m_20185_() + lookAngle.f_82479_ * 0.5, this.m_20186_() + 0.35, this.m_20189_() + lookAngle.f_82481_ * 0.5);
            golem.setLit(true);
            golem.setSummoner(this.m_20148_());
            this.m_9236_().m_7967_((Entity)golem);
            golem.m_6710_(this.m_5448_());
            golem.m_6710_(this.m_5448_());
        }
        for (i = 0; i < 10; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_() - 0.75, this.m_20262_(0.5), (this.f_19796_.m_188500_() - 0.5) * 0.5, -this.f_19796_.m_188500_(), (this.f_19796_.m_188500_() - 0.5) * 0.5);
        }
    }
}

