/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;
import tech.alexnijjar.golemoverhaul.common.utils.ModUtils;

public class CoalGolem
extends BaseGolem {
    public static final int DEATH_TICKS = 13;
    public static final int MAX_SUMMON_TICKS = 2400;
    private static final EntityDataAccessor<Boolean> ID_LIT = SynchedEntityData.m_135353_(CoalGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean summoned;
    @Nullable
    private UUID summonerId;

    public CoalGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 1;
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnCoalGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        if (level.m_204166_(pos).m_203565_(Biomes.f_220594_)) {
            return false;
        }
        return pos.m_123342_() < level.m_5736_() && !level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "death_controller", 5, state -> {
            if (this.f_20919_ == 0) {
                return PlayState.STOP;
            }
            return state.setAndContinue(ConstantAnimations.DIE);
        })});
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LIT, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Lit", this.isLit());
        if (this.summonerId != null) {
            compound.m_128362_("SummonerId", this.summonerId);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLit(compound.m_128471_("Lit"));
        if (compound.m_128403_("SummonerId")) {
            this.setSummoner(compound.m_128342_("SummonerId"));
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
    }

    @Override
    public boolean canTarget() {
        return this.isLit() || this.isSummoned();
    }

    public boolean isLit() {
        return (Boolean)this.f_19804_.m_135370_(ID_LIT);
    }

    public void setLit(boolean lit) {
        this.f_19804_.m_135381_(ID_LIT, (Object)lit);
        this.m_21051_(Attributes.f_22281_).m_22100_(lit ? 12.0 : 2.0);
        this.updateAttackGoals();
    }

    public boolean isSummoned() {
        return this.summoned;
    }

    public void setSummoner(@Nullable UUID summoner) {
        this.summoned = summoner != null;
        this.summonerId = summoner;
    }

    protected void m_6668_(DamageSource damageSource) {
        if (this.isSummoned()) {
            return;
        }
        super.m_6668_(damageSource);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.isLit() || this.f_20919_ >= 13 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.removeAndAddDeathParticles();
        }
    }

    protected SoundEvent m_7515_() {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_AMBIENT.get() : super.m_7515_();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_HURT.get() : super.m_7975_(damageSource);
    }

    @Override
    protected SoundEvent m_5592_() {
        return this.isLit() ? (SoundEvent)ModSoundEvents.COAL_GOLEM_DEATH.get() : super.m_5592_();
    }

    @Override
    public IronGolem.Crackiness getCrackiness() {
        return IronGolem.Crackiness.NONE;
    }

    @Override
    public boolean shouldAttack(LivingEntity entity) {
        if (entity instanceof Creeper) {
            return this.isLit();
        }
        return super.shouldAttack(entity);
    }

    public void m_20093_() {
        super.m_20093_();
        this.setLit(true);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            this.setLit(true);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    @Override
    public int getAttackTicks() {
        return 10;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42413_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return this.m_21233_();
    }

    public void m_252836_() {
        super.m_252836_();
        if (this.isLit()) {
            this.setLit(false);
            this.m_216990_(SoundEvents.f_11914_);
            for (int i = 0; i < 20; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_() + this.f_19796_.m_188583_() * 0.3, this.m_20186_() + 0.5 + this.f_19796_.m_188583_() * 0.3, this.m_20189_() + this.f_19796_.m_188583_() * 0.3, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            if (this.isLit() && !this.m_9236_().m_5776_()) {
                target.m_20254_(5);
                this.m_6074_();
                this.f_20919_ = 10;
                this.m_216990_((SoundEvent)ModSoundEvents.COAL_GOLEM_EXPLODE.get());
                for (int i = 0; i < 10; ++i) {
                    ModUtils.sendParticles((ServerLevel)this.m_9236_(), ParticleTypes.f_123744_, this.m_20185_() + this.f_19796_.m_188583_() * 0.3, this.m_20186_() + 0.5 + this.f_19796_.m_188583_() * 0.3, this.m_20189_() + this.f_19796_.m_188583_() * 0.3, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    public void m_8119_() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            Entity summoner;
            ServerLevel level2 = (ServerLevel)level;
            if (this.f_19797_ > 2400 && this.isSummoned()) {
                this.m_6074_();
                this.m_216990_((SoundEvent)ModSoundEvents.COAL_GOLEM_EXPLODE.get());
            }
            if (this.summonerId != null && (summoner = level2.m_8791_(this.summonerId)) instanceof Mob) {
                Mob mob = (Mob)summoner;
                this.m_6710_(mob.m_5448_());
            }
        }
        super.m_8119_();
    }

    @Override
    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        if (super.m_6071_(player, hand).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (this.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.isLit()) {
            if (stack.m_41619_()) {
                this.m_252836_();
                return InteractionResult.SUCCESS;
            }
        } else {
            if (stack.m_41720_() instanceof FlintAndSteelItem) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                this.m_216990_(SoundEvents.f_11942_);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() instanceof FireChargeItem) {
                stack.m_41774_(1);
                this.m_216990_(SoundEvents.f_11874_);
                this.setLit(true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(1.0, 0.0, 1.0);
    }
}

