/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.renderer.GeoRenderer;
import tech.alexnijjar.golemoverhaul.GolemOverhaul;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.layers.NetheriteGolemFireLayer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.layers.NetheriteGolemGoldLayer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.NetheriteGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class NetheriteGolemRenderer
extends BaseGolemRenderer<NetheriteGolem> {
    public static final ResourceLocation GOLD_OVERLAY = GolemOverhaul.asResource("textures/entity/netherite/netherite_golem_gold_overlay.png");
    public static final ResourceLocation CHARGED_OVERLAY = GolemOverhaul.asResource("textures/entity/netherite/netherite_golem_charged_glow.png");
    public static final ResourceLocation CHARGED_OVERLAY_OPEN = GolemOverhaul.asResource("textures/entity/netherite/netherite_golem_charged_glow_open.png");

    public NetheriteGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<NetheriteGolem>(ModEntityTypes.NETHERITE_GOLEM, true, 10));
        this.withScale(1.2f);
        this.addRenderLayer(new NetheriteGolemGoldLayer((GeoRenderer<NetheriteGolem>)this));
        this.addRenderLayer(new NetheriteGolemFireLayer((GeoRenderer<NetheriteGolem>)this));
    }

    protected void applyRotations(NetheriteGolem golem, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        int deathTime = golem.f_20919_;
        golem.f_20919_ = 0;
        super.applyRotations((Entity)golem, poseStack, ageInTicks, rotationYaw, partialTick);
        golem.f_20919_ = deathTime;
    }
}

