/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.IronGolem;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.alexnijjar.golemoverhaul.GolemOverhaul;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.utils.ModRenderTypes;
import tech.alexnijjar.golemoverhaul.common.entities.golems.CandleGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class CandleGolemRenderer
extends BaseGolemRenderer<CandleGolem> {
    public static final ResourceLocation GLOW_1 = GolemOverhaul.asResource("textures/entity/candle/candle_golem_1_glow.png");
    public static final ResourceLocation GLOW_2 = GolemOverhaul.asResource("textures/entity/candle/candle_golem_2_glow.png");
    public static final ResourceLocation MODEL_1 = GolemOverhaul.asResource("geo/entity/candle/candle_golem_1.geo.json");
    public static final ResourceLocation MODEL_2 = GolemOverhaul.asResource("geo/entity/candle/candle_golem_2.geo.json");
    public static final ResourceLocation MODEL_3 = GolemOverhaul.asResource("geo/entity/candle/candle_golem_3.geo.json");

    public CandleGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<CandleGolem>(ModEntityTypes.CANDLE_GOLEM, true, 90){

            public ResourceLocation getModelResource(CandleGolem golem) {
                return switch (golem.getCrackiness()) {
                    default -> throw new IncompatibleClassChangeError();
                    case IronGolem.Crackiness.NONE, IronGolem.Crackiness.LOW -> MODEL_1;
                    case IronGolem.Crackiness.MEDIUM -> MODEL_2;
                    case IronGolem.Crackiness.HIGH -> MODEL_3;
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<CandleGolem>((GeoRenderer)this){

            protected RenderType getRenderType(CandleGolem golem) {
                return switch (golem.getCrackiness()) {
                    default -> throw new IncompatibleClassChangeError();
                    case IronGolem.Crackiness.NONE, IronGolem.Crackiness.LOW -> ModRenderTypes.eyesNoCull(GLOW_1);
                    case IronGolem.Crackiness.MEDIUM -> ModRenderTypes.eyesNoCull(GLOW_2);
                    case IronGolem.Crackiness.HIGH -> super.getRenderType((GeoAnimatable)golem);
                };
            }

            public void render(PoseStack poseStack, CandleGolem golem, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
                if (golem.isLit()) {
                    super.render(poseStack, (GeoAnimatable)golem, bakedModel, renderType, bufferSource, buffer, partialTick, packedLight, packedOverlay);
                }
            }
        });
    }
}

