/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.compat;

import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import tech.alexnijjar.golemoverhaul.GolemOverhaul;
import tech.alexnijjar.golemoverhaul.client.compat.FakeLevel;
import tech.alexnijjar.golemoverhaul.common.recipes.GolemConstructionRecipe;

public class GolemConstructionRenderer {
    public static final ResourceLocation TEXTURE = GolemOverhaul.asResource("textures/gui/container/golem_construction.png");
    private final FakeLevel fakeLevel;
    private final Entity entity;
    private final int x;
    private final int y;
    private final float blockScale;
    private final float entityScale;
    private final boolean single;
    private final MutableComponent blockTooltip = Component.m_237119_();

    public GolemConstructionRenderer(GolemConstructionRecipe recipe, int x, int y) {
        this.x = x;
        this.y = y;
        this.blockScale = recipe.getBlockScale();
        this.entityScale = recipe.getEntityScale();
        HashMap<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
        this.fakeLevel = new FakeLevel(blocks);
        Optional firstPatternRow = recipe.getPattern().stream().findFirst();
        if (firstPatternRow.isEmpty()) {
            throw new RuntimeException("Recipe contains empty pattern row");
        }
        int width = ((String)firstPatternRow.get()).length();
        int height = recipe.getPattern().size();
        this.single = width == 1 && height == 1;
        for (int i = 0; i < height; ++i) {
            String row = recipe.getPattern().get(i);
            for (int j = 0; j < width; ++j) {
                char c = row.charAt(j);
                ResourceKey<Block> key = recipe.getKey().get(String.valueOf(c));
                if (key == null) {
                    throw new IllegalStateException("Invalid key: " + c);
                }
                if (key.m_135782_().equals((Object)BuiltInRegistries.f_256975_.m_7981_((Object)Blocks.f_50016_))) continue;
                BlockState state = ((Block)BuiltInRegistries.f_256975_.m_123013_(key)).m_49966_();
                blocks.put(BlockPos.m_274561_((double)(width - j - 1), (double)(height - i - 1), (double)0.0), state);
                this.blockTooltip.m_7220_((Component)state.m_60734_().m_49954_());
                if (i == height - 1) continue;
                this.blockTooltip.m_130946_("\n");
            }
        }
        EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_6246_(recipe.getEntity());
        if (type == null) {
            throw new IllegalStateException("Invalid entity: " + String.valueOf(recipe.getEntity()));
        }
        this.entity = type.m_20615_((Level)Objects.requireNonNull(Minecraft.m_91087_().f_91073_));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY) {
        this.entity.m_5616_(0.0f);
        graphics.m_280163_(TEXTURE, this.x - 47, this.y - 58, 0.0f, 0.0f, 180, 76, 180, 76);
        try (CloseablePoseStack pose = new CloseablePoseStack(graphics);){
            pose.m_252880_((float)this.x, (float)this.y, 100.0f);
            pose.m_252880_(10.0f, -5.0f, 0.0f);
            pose.m_85841_(-20.0f, -20.0f, -20.0f);
            pose.m_85841_(this.blockScale, this.blockScale, this.blockScale);
            if (this.single) {
                pose.m_85837_(0.1, 0.2, 0.0);
            }
            pose.m_85837_(0.5, 0.5, 0.5);
            pose.m_252781_(Axis.f_252529_.m_252977_(-30.0f));
            pose.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            pose.m_85837_(-0.5, -0.5, -0.5);
            this.fakeLevel.renderBlocks(graphics.m_280168_());
        }
        pose = new CloseablePoseStack(graphics);
        try {
            pose.m_252880_(95.0f, -7.0f, 0.0f);
            Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ((float)Math.toRadians(30.0), (float)Math.toRadians(135.0), (float)Math.PI);
            InventoryScreen.m_280432_((GuiGraphics)graphics, (int)this.x, (int)this.y, (int)((int)(32.0f * this.entityScale)), (Quaternionf)ARMOR_STAND_ANGLE, null, (LivingEntity)((LivingEntity)this.entity));
        }
        finally {
            pose.close();
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen == null) {
            return;
        }
        if (mouseX >= this.x + 68 && mouseX < this.x + 120 && mouseY >= this.y - 48 && mouseY < this.y + 8) {
            screen.m_262791_(Tooltip.m_257550_((Component)this.entity.m_7755_()), DefaultTooltipPositioner.f_262752_, true);
        } else if (mouseX >= this.x - 34 && mouseX < this.x + 18 && mouseY >= this.y - 48 && mouseY < this.y + 8) {
            screen.m_262791_(Tooltip.m_257550_((Component)this.blockTooltip), DefaultTooltipPositioner.f_262752_, true);
        }
    }

    public int getWidth() {
        return 180;
    }

    public int getHeight() {
        return 76;
    }
}

