/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.impl.movement.RemotePlayerMovement;
import tictim.paraglider.impl.vessel.SimpleVesselContainer;

public class ClientPlayerMovement
extends RemotePlayerMovement {
    private boolean wasParagliding;

    public ClientPlayerMovement(@NotNull LocalPlayer player) {
        super((Player)player);
    }

    @NotNull
    public LocalPlayer player() {
        return (LocalPlayer)super.player();
    }

    @Override
    @NotNull
    protected Stamina createStamina() {
        return ParagliderAPI.staminaFactory().createLocalClientInstance(this.player());
    }

    @Override
    @NotNull
    protected VesselContainer createVesselContainer() {
        return new SimpleVesselContainer((Player)this.player());
    }

    @Override
    public void update() {
        this.stamina().update(this);
        LocalPlayer player = this.player();
        boolean paragliding = this.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        if (!player.m_7500_() && this.stamina().isDepleted()) {
            player.m_6858_(false);
            player.m_20282_(false);
        } else if (this.wasParagliding != paragliding) {
            player.m_6858_(paragliding);
        }
        this.applyMovement();
        this.wasParagliding = paragliding;
    }
}

