/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.event;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindUtils;

@Mod.EventBusSubscriber(modid="paraglider")
public final class WindEventHandler {
    private WindEventHandler() {
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        Wind.registerLevel(event.getLevel());
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        Wind.unregisterLevel(event.getLevel());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !event.side.isServer()) {
            return;
        }
        WindUtils.updateWind(event.level);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind != null) {
            wind.remove(event.getChunk().m_7697_());
        }
    }

    @SubscribeEvent
    public static void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerLevel level = event.getLevel();
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return;
        }
        ChunkPos pos = event.getPos();
        WindChunk windChunk = wind.getChunk(pos);
        if (windChunk == null || windChunk.isEmpty()) {
            return;
        }
        ParagliderNetwork.get().syncWind(level.m_7654_(), level.m_6325_(pos.f_45578_, pos.f_45579_), windChunk);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return;
        }
        WindUtils.placeWindParticles((Level)level, wind);
    }
}

