/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.network.ClientPacketHandler;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.network.ParagliderNetworkBase;
import tictim.paraglider.network.ServerPacketHandler;
import tictim.paraglider.network.message.BargainDialogMsg;
import tictim.paraglider.network.message.BargainEndMsg;
import tictim.paraglider.network.message.BargainInitMsg;
import tictim.paraglider.network.message.BargainMsg;
import tictim.paraglider.network.message.Msg;
import tictim.paraglider.network.message.SyncCatalogMsg;
import tictim.paraglider.network.message.SyncLookAtMsg;
import tictim.paraglider.network.message.SyncMovementMsg;
import tictim.paraglider.network.message.SyncPlayerStateMapMsg;
import tictim.paraglider.network.message.SyncRemoteMovementMsg;
import tictim.paraglider.network.message.SyncVesselMsg;
import tictim.paraglider.network.message.SyncWindMsg;

public final class ForgeParagliderNetwork
extends ParagliderNetworkBase {
    private static final ForgeParagliderNetwork instance = new ForgeParagliderNetwork();
    public static final String NETVERSION = "2.0";
    private final SimpleChannel net = NetworkRegistry.newSimpleChannel((ResourceLocation)ParagliderAPI.id("master"), () -> "2.0", "2.0"::equals, "2.0"::equals);

    @NotNull
    public static ParagliderNetwork get() {
        return instance;
    }

    public static void init() {
    }

    private ForgeParagliderNetwork() {
        this.net.registerMessage(0, SyncPlayerStateMapMsg.class, SyncPlayerStateMapMsg::write, SyncPlayerStateMapMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncPlayerStateMap(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(1, SyncMovementMsg.class, SyncMovementMsg::write, SyncMovementMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncMovement(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(2, SyncRemoteMovementMsg.class, SyncRemoteMovementMsg::write, SyncRemoteMovementMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncRemoteMovement(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(3, SyncVesselMsg.class, SyncVesselMsg::write, SyncVesselMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncVessel(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(4, BargainInitMsg.class, BargainInitMsg::write, BargainInitMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleBargainInit(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(5, SyncCatalogMsg.class, SyncCatalogMsg::write, SyncCatalogMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncCatalog(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(6, SyncLookAtMsg.class, SyncLookAtMsg::write, SyncLookAtMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncLookAt(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(7, BargainDialogMsg.class, BargainDialogMsg::write, BargainDialogMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleBargainDialog(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        this.net.registerMessage(8, BargainMsg.class, BargainMsg::write, BargainMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgeParagliderNetwork.lambda$new$17((Supplier)ctx, msg));
        }, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.net.registerMessage(9, BargainEndMsg.class, BargainEndMsg::write, BargainEndMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ForgeParagliderNetwork.lambda$new$19((Supplier)ctx, msg));
        });
        this.net.registerMessage(10, SyncWindMsg.class, SyncWindMsg::write, SyncWindMsg::read, (msg, ctx) -> {
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> ClientPacketHandler.handleSyncWind(msg));
        }, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    protected void sendToAll(@NotNull MinecraftServer server, @NotNull Msg msg) {
        this.net.send(PacketDistributor.ALL.noArg(), (Object)msg);
    }

    @Override
    protected void sendToPlayer(@NotNull ServerPlayer player, @NotNull Msg msg) {
        this.net.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    @Override
    protected void sendToTracking(@NotNull MinecraftServer server, @NotNull Entity entity, @NotNull Msg msg) {
        this.net.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)msg);
    }

    @Override
    protected void sendToTracking(@NotNull MinecraftServer server, @NotNull LevelChunk chunk, @NotNull Msg msg) {
        this.net.send(PacketDistributor.TRACKING_CHUNK.with(() -> chunk), (Object)msg);
    }

    @Override
    protected void sendToServer(@NotNull Msg msg) {
        this.net.sendToServer((Object)msg);
    }

    private static /* synthetic */ void lambda$new$19(Supplier ctx, BargainEndMsg msg) {
        switch (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide()) {
            case CLIENT: {
                ClientPacketHandler.handleBargainEnd(msg);
                break;
            }
            case SERVER: {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) break;
                ServerPacketHandler.handleBargainEnd(player, msg);
            }
        }
    }

    private static /* synthetic */ void lambda$new$17(Supplier ctx, BargainMsg msg) {
        ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
        if (player == null) {
            return;
        }
        ServerPacketHandler.handleBargain(player, msg);
    }
}

