/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;

public final class BlockMatcher {
    private static final BlockMatcher empty = new BlockMatcher(new String[0], null, null);
    private static final Pattern REGEX = Pattern.compile("^#((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)|((?:[a-z0-9_.-]+:)?[a-z0-9_.-]+)(?:\\s*#\\s*([A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+(?:\\s*,\\s*[A-Za-z0-9_.-]+\\s*=\\s*[A-Za-z0-9_.-]+)*))?$");
    private static final int GROUP_TAG = 1;
    private static final int GROUP_BLOCK_ID = 2;
    private static final int GROUP_PROPERTIES = 3;
    private final String[] inputs;
    private final Map<Block, Predicate<BlockState>> blockMatches;
    private final Set<TagKey<Block>> tagMatches;

    @NotNull
    public static BlockMatcher empty() {
        return empty;
    }

    @NotNull
    public static Result parse(@NotNull Collection<? extends String> inputs) {
        return new Result(inputs.toArray(new String[0]));
    }

    @NotNull
    public static BlockMatcher read(@NotNull FriendlyByteBuf buffer) {
        String[] inputs = new String[buffer.m_130242_()];
        for (int i = 0; i < inputs.length; ++i) {
            inputs[i] = buffer.m_130277_();
        }
        return new Result(inputs).result();
    }

    private BlockMatcher(@NotNull @NotNull String @NotNull [] inputs, @Nullable Map<@NotNull Block, Predicate<BlockState>> blockMatches, @Nullable Set<@NotNull TagKey<Block>> tagMatches) {
        this.inputs = inputs;
        this.blockMatches = blockMatches;
        this.tagMatches = tagMatches;
    }

    public boolean test(@NotNull BlockState state) {
        Predicate<BlockState> predicate;
        if (this.blockMatches != null && (predicate = this.blockMatches.get(state.m_60734_())) != null && predicate.test(state)) {
            return true;
        }
        if (this.tagMatches != null) {
            for (TagKey<Block> tag : this.tagMatches) {
                if (!ParagliderUtils.hasTag(state.m_60734_(), tag)) continue;
                return true;
            }
        }
        return false;
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130130_(this.inputs.length);
        for (String input : this.inputs) {
            buffer.m_130070_(input);
        }
    }

    public static final class Result {
        private final BlockMatcher result;
        @Nullable
        private List<Error> errors;

        private Result(@NotNull @NotNull String @NotNull [] inputs) {
            Object2ObjectOpenHashMap blockMatches = null;
            ObjectOpenHashSet tagMatches = null;
            Matcher m = REGEX.matcher("");
            for (String input : inputs) {
                if (!m.reset(input).matches()) {
                    this.addError(input, "Malformed input");
                    continue;
                }
                if (m.group(1) != null) {
                    if (tagMatches == null) {
                        tagMatches = new ObjectOpenHashSet();
                    }
                    tagMatches.add(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(m.group(1))));
                    continue;
                }
                Block block = ParagliderUtils.getBlock(new ResourceLocation(m.group(2)));
                if (block == Blocks.f_50016_) {
                    this.addError(input, "No block named '" + m.group(2) + "' exists");
                    continue;
                }
                Predicate<BlockState> p = this.parseBlockMatch(input, m, block);
                if (p == null) continue;
                if (blockMatches == null) {
                    blockMatches = new Object2ObjectOpenHashMap();
                }
                blockMatches.compute(block, (k, v) -> v == null ? p : v.or(p));
            }
            this.result = new BlockMatcher(inputs, (Map<Block, Predicate<BlockState>>)blockMatches, (Set<TagKey<Block>>)tagMatches);
        }

        @Nullable
        private Predicate<BlockState> parseBlockMatch(String input, Matcher matcher, Block block) {
            String blockState = matcher.group(3);
            if (blockState == null) {
                return BlockStatePredicate.f_61281_;
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            for (String s : blockState.split(",")) {
                int i = s.indexOf(61);
                String key = s.substring(0, i);
                if (properties.containsKey(key)) {
                    this.addError(input, "Same property '" + key + "' checked twice");
                    return null;
                }
                properties.put(key, s.substring(i + 1));
            }
            IdentityHashMap parsedProperties = new IdentityHashMap();
            for (Map.Entry e : properties.entrySet()) {
                String key = (String)e.getKey();
                Property property = block.m_49965_().m_61081_(key);
                if (property == null) {
                    this.addError(input, "Property with name '" + key + "' does not exist on block properties");
                    return null;
                }
                if (parsedProperties.containsKey(property)) {
                    this.addError(input, "Same property '" + key + "' checked twice");
                    return null;
                }
                Optional o2 = property.m_6215_((String)e.getValue());
                if (o2.isEmpty()) {
                    this.addError(input, "Property with name '" + key + "' does not contain value '" + (String)e.getValue() + "'");
                    return null;
                }
                parsedProperties.put(property, o2.get());
            }
            BlockStatePredicate m = BlockStatePredicate.m_61287_((Block)block);
            for (Map.Entry e : parsedProperties.entrySet()) {
                Object v = e.getValue();
                m.m_61295_((Property)e.getKey(), o -> o != null && o.equals(v));
            }
            return m;
        }

        private void addError(String input, String cause) {
            if (this.errors == null) {
                this.errors = new ArrayList<Error>();
            }
            this.errors.add(new Error(input, cause));
        }

        @NotNull
        public BlockMatcher result() {
            return this.result;
        }

        @NotNull
        public @Unmodifiable List<Error> errors() {
            return this.errors == null ? List.of() : Collections.unmodifiableList(this.errors);
        }

        public void printErrors() {
            if (this.errors == null || this.errors.isEmpty()) {
                return;
            }
            ParagliderMod.LOGGER.warn("Found {} error(s) in wind source configuration:", (Object)this.errors.size());
            for (Error error : this.errors) {
                ParagliderMod.LOGGER.warn("  \"{}\": {}", (Object)error.input, (Object)error.cause);
            }
        }
    }

    public record Error(String input, String cause) {
    }
}

