/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.client.render;

import net.minecraft.util.FastColor;

public final class StaminaWheelConstants {
    public static final int IDLE = FastColor.ARGB32.m_13660_((int)255, (int)0, (int)223, (int)83);
    public static final int GLOW = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    public static final int EVIL_GLOW = FastColor.ARGB32.m_13660_((int)255, (int)248, (int)223, (int)223);
    public static final int TRANSPARENT = FastColor.ARGB32.m_13660_((int)0, (int)255, (int)255, (int)255);
    public static final int DEPLETED_1 = FastColor.ARGB32.m_13660_((int)255, (int)150, (int)2, (int)2);
    public static final int DEPLETED_2 = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)150, (int)2);
    public static final int EMPTY = FastColor.ARGB32.m_13660_((int)150, (int)2, (int)2, (int)2);
    public static final long GLOW_FADE_START = 100L;
    public static final long GLOW_FADE_DURATION = 250L;
    public static final long GLOW_FADE_END = 350L;
    public static final long FADE_START = 1000L;
    public static final long FADE_DURATION = 100L;
    public static final long FADE_END = 1100L;
    public static final long BLINK = 300L;
    public static final long DEPLETED_BLINK = 600L;
    public static final int WHEEL_RADIUS = 10;

    private StaminaWheelConstants() {
    }

    public static int getGlowAndFadeColor(long time) {
        if (time < 100L) {
            return GLOW;
        }
        if (time < 350L) {
            return FastColor.ARGB32.m_269105_((float)((float)(time - 100L) / 250.0f), (int)GLOW, (int)IDLE);
        }
        if (time < 1000L) {
            return IDLE;
        }
        if (time < 1100L) {
            return FastColor.ARGB32.m_269105_((float)((float)(time - 1000L) / 100.0f), (int)IDLE, (int)TRANSPARENT);
        }
        return TRANSPARENT;
    }

    public static int getBlinkColor(long time, boolean depleted) {
        return FastColor.ARGB32.m_269105_((float)StaminaWheelConstants.cycle(time, depleted ? 600L : 300L), (int)DEPLETED_1, (int)DEPLETED_2);
    }

    public static float cycle(long currentTime, long cycleTime) {
        long halfCycle = cycleTime / 2L;
        return (float)Math.abs(currentTime % cycleTime - halfCycle) / (float)halfCycle;
    }
}

