/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.satisfy.brewery.Brewery;
import net.satisfy.brewery.effect.BlackoutEffect;
import net.satisfy.brewery.effect.CombustionEffect;
import net.satisfy.brewery.effect.DrunkEffect;
import net.satisfy.brewery.effect.ExplosionEffect;
import net.satisfy.brewery.effect.HaleyEffect;
import net.satisfy.brewery.effect.HealingTouchEffect;
import net.satisfy.brewery.effect.LightningStrikeEffect;
import net.satisfy.brewery.effect.MiningEffect;
import net.satisfy.brewery.effect.PacifyEffect;
import net.satisfy.brewery.effect.PartystarterEffect;
import net.satisfy.brewery.effect.PintCharismaEffect;
import net.satisfy.brewery.effect.ProtectiveTouchEffect;
import net.satisfy.brewery.effect.RenewingTouchEffect;
import net.satisfy.brewery.effect.RepulsionEffect;
import net.satisfy.brewery.effect.SnowWhiteEffect;
import net.satisfy.brewery.effect.ToxicTouchEffect;
import net.satisfy.brewery.util.BreweryIdentifier;

public class MobEffectRegistry {
    public static final RegistrySupplier<MobEffect> DRUNK;
    public static final RegistrySupplier<MobEffect> BLACKOUT;
    public static final RegistrySupplier<MobEffect> RENEWINGTOUCH;
    public static final RegistrySupplier<MobEffect> TOXICTOUCH;
    public static final RegistrySupplier<MobEffect> HEALINGTOUCH;
    public static final RegistrySupplier<MobEffect> PROTECTIVETOUCH;
    public static final RegistrySupplier<MobEffect> PARTYSTARTER;
    public static final RegistrySupplier<MobEffect> SNOWWHITE;
    public static final RegistrySupplier<MobEffect> PINTCHARISMA;
    public static final RegistrySupplier<MobEffect> HALEY;
    public static final RegistrySupplier<MobEffect> MINING;
    public static final RegistrySupplier<MobEffect> PACIFY;
    public static final RegistrySupplier<MobEffect> COMBUSTION;
    public static final RegistrySupplier<MobEffect> EXPLOSION;
    public static final RegistrySupplier<MobEffect> REPULSION;
    public static final RegistrySupplier<MobEffect> LIGHTNING_STRIKE;
    private static final DeferredRegister<MobEffect> MOB_EFFECTS;
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register((ResourceLocation)new BreweryIdentifier(name), effect);
    }

    public static void init() {
        Brewery.LOGGER.debug("Mob effects");
        MOB_EFFECTS.register();
    }

    static {
        MOB_EFFECTS = DeferredRegister.create((String)"brewery", (ResourceKey)Registries.f_256929_);
        MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
        DRUNK = MobEffectRegistry.registerEffect("drunk", DrunkEffect::new);
        BLACKOUT = MobEffectRegistry.registerEffect("blackout", () -> new BlackoutEffect().m_216879_(() -> new MobEffectInstance.FactorData(22)));
        MINING = MobEffectRegistry.registerEffect("mining", () -> new MiningEffect(MobEffectCategory.BENEFICIAL, 0));
        PACIFY = MobEffectRegistry.registerEffect("pacify", () -> new PacifyEffect(MobEffectCategory.BENEFICIAL, 0));
        REPULSION = MobEffectRegistry.registerEffect("repulsion", () -> new RepulsionEffect(MobEffectCategory.BENEFICIAL, 0));
        LIGHTNING_STRIKE = MobEffectRegistry.registerEffect("lightning_strike", () -> new LightningStrikeEffect(MobEffectCategory.BENEFICIAL, 0));
        EXPLOSION = MobEffectRegistry.registerEffect("explosion", () -> new ExplosionEffect(MobEffectCategory.BENEFICIAL, 0));
        COMBUSTION = MobEffectRegistry.registerEffect("combustion", () -> new CombustionEffect(MobEffectCategory.BENEFICIAL, 0));
        TOXICTOUCH = MobEffectRegistry.registerEffect("toxictouch", () -> new ToxicTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        RENEWINGTOUCH = MobEffectRegistry.registerEffect("renewingtouch", () -> new RenewingTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        HEALINGTOUCH = MobEffectRegistry.registerEffect("healingtouch", () -> new HealingTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        PROTECTIVETOUCH = MobEffectRegistry.registerEffect("protectivetouch", () -> new ProtectiveTouchEffect(MobEffectCategory.BENEFICIAL, 0));
        PARTYSTARTER = MobEffectRegistry.registerEffect("partystarter", () -> new PartystarterEffect(MobEffectCategory.BENEFICIAL, 0));
        SNOWWHITE = MobEffectRegistry.registerEffect("snowwhite", () -> new SnowWhiteEffect(MobEffectCategory.BENEFICIAL, 0));
        PINTCHARISMA = MobEffectRegistry.registerEffect("pintcharisma", () -> new PintCharismaEffect(MobEffectCategory.BENEFICIAL, 0));
        HALEY = MobEffectRegistry.registerEffect("haley", () -> new HaleyEffect(MobEffectCategory.BENEFICIAL, 0));
    }
}

