/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.effect;

import dev.architectury.networking.NetworkManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.satisfy.brewery.effect.alcohol.AlcoholLevel;
import net.satisfy.brewery.effect.alcohol.AlcoholManager;
import net.satisfy.brewery.effect.alcohol.AlcoholPlayer;
import net.satisfy.brewery.networking.BreweryNetworking;
import net.satisfy.brewery.registry.MobEffectRegistry;

public class DrunkEffect
extends MobEffect {
    public DrunkEffect() {
        super(MobEffectCategory.BENEFICIAL, 14736687);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (livingEntity instanceof AlcoholPlayer) {
            AlcoholPlayer alcoholPlayer = (AlcoholPlayer)livingEntity;
            AlcoholLevel alcoholLevel = alcoholPlayer.getAlcohol();
            if (alcoholLevel.isDrunk() && livingEntity.m_217043_().m_188501_() < 0.5f) {
                alcoholLevel.gainImmunity();
            }
            alcoholLevel.sober();
            if (!alcoholLevel.isSober()) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.DRUNK.get(), 600, alcoholLevel.getDrunkenness() - 1, false, alcoholLevel.isDrunk()));
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                AlcoholManager.syncAlcohol(serverPlayer, alcoholLevel);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMap, int i) {
        if (livingEntity instanceof AlcoholPlayer) {
            AlcoholLevel alcoholLevel;
            AlcoholPlayer alcoholPlayer = (AlcoholPlayer)livingEntity;
            int amplifier = this.getDrunkAmplifier(livingEntity);
            if (amplifier >= (alcoholLevel = alcoholPlayer.getAlcohol()).getImmunity() - 1) {
                this.setDrunkEffect(livingEntity, true);
            }
        }
        super.m_6385_(livingEntity, attributeMap, i);
    }

    public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMap, int i) {
        AlcoholPlayer alcoholPlayer;
        AlcoholLevel alcoholLevel;
        if (livingEntity instanceof AlcoholPlayer && !(alcoholLevel = (alcoholPlayer = (AlcoholPlayer)livingEntity).getAlcohol()).isDrunk()) {
            this.setDrunkEffect(livingEntity, false);
        }
        super.m_6386_(livingEntity, attributeMap, i);
    }

    private int getDrunkAmplifier(LivingEntity livingEntity) {
        MobEffectInstance effect = livingEntity.m_21124_((MobEffect)MobEffectRegistry.DRUNK.get());
        return effect != null ? effect.m_19564_() : 0;
    }

    private void setDrunkEffect(LivingEntity livingEntity, boolean activate) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            FriendlyByteBuf buf = BreweryNetworking.createPacketBuf();
            buf.writeBoolean(activate);
            NetworkManager.sendToPlayer((ServerPlayer)serverPlayer, (ResourceLocation)BreweryNetworking.DRUNK_EFFECT_S2C_ID, (FriendlyByteBuf)buf);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration == 1;
    }
}

