/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.block.brewingstation;

import de.cristelknight.doapi.common.registry.DoApiSoundEventRegistry;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.block.brewingstation.BrewingstationBlock;
import net.satisfy.brewery.block.property.BrewMaterial;
import net.satisfy.brewery.block.property.Heat;
import net.satisfy.brewery.registry.BlockStateRegistry;
import org.jetbrains.annotations.NotNull;

public class BrewOvenBlock
extends BrewingstationBlock {
    public static final EnumProperty<Heat> HEAT = BlockStateRegistry.HEAT;
    public static final Map<Direction, VoxelShape> SHAPE;
    private static final Supplier<VoxelShape> voxelShapeSupplier;
    private long lastSoundTime = 0L;

    public BrewOvenBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> BrewOvenBlock.hasHeat(state) ? 13 : 0));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)MATERIAL, (Comparable)((Object)BrewMaterial.WOOD))).m_61124_(HEAT, (Comparable)((Object)Heat.OFF)));
    }

    private static boolean hasHeat(BlockState state) {
        return state.m_61143_(HEAT) != Heat.OFF;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (blockState.m_61143_(HEAT) != Heat.LIT && AbstractFurnaceBlockEntity.m_58423_().containsKey(itemStack.m_41720_())) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_(HEAT, (Comparable)((Object)Heat.LIT)), 3);
            level.m_5594_(null, blockPos, SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        Player player;
        boolean isHeated;
        boolean bl = isHeated = state.m_61143_(HEAT) != Heat.OFF;
        if (isHeated && !entity.m_5825_() && entity instanceof Player && !EnchantmentHelper.m_44938_((LivingEntity)(player = (Player)entity))) {
            entity.m_6469_(world.m_269111_().m_269387_(), 1.0f);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (blockState.m_61143_(HEAT) != Heat.OFF) {
            double k;
            double x = (double)blockPos.m_123341_() + 0.5;
            double y = (double)blockPos.m_123342_() + 0.7;
            double z = (double)blockPos.m_123343_() + 0.5;
            if (randomSource.m_188500_() < 0.1) {
                level.m_7785_(x, y, z, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = ((Direction)blockState.m_61143_((Property)f_54117_)).m_122428_();
            Direction.Axis axis = direction.m_122434_();
            double h = randomSource.m_188500_() * 0.6 - 0.3;
            double i = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.62 : h;
            double j = randomSource.m_188500_() * 9.0 / 16.0;
            double d = k = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.62 : h;
            if (blockState.m_61143_(HEAT) == Heat.WEAK) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastSoundTime >= 9500L) {
                    level.m_7785_(x, y, z, (SoundEvent)DoApiSoundEventRegistry.BREWSTATION_OVEN.get(), SoundSource.BLOCKS, 0.7f, 1.0f, false);
                    this.lastSoundTime = currentTime;
                }
                if (randomSource.m_188500_() < 0.2) {
                    for (int l = 0; l < 5; ++l) {
                        level.m_7106_((ParticleOptions)ParticleTypes.f_123778_, x + i, y + j, z + k, 0.0, 0.01, 0.0);
                    }
                }
            } else {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + i, y + j, z + k, 0.0, 0.07, 0.0);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x + i, y + j, z + k, 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT});
    }

    static {
        voxelShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)0.875));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.0, (double)1.0, (double)1.0, (double)0.9375));
            return shape;
        };
        SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
            }
        });
    }
}

