/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.placebo.json;

import dev.shadowsoffire.placebo.Placebo;
import dev.shadowsoffire.placebo.json.GearSet;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;

public class GearSetRegistry
extends WeightedDynamicRegistry<GearSet> {
    public static final GearSetRegistry INSTANCE = new GearSetRegistry();

    public GearSetRegistry() {
        super(Placebo.LOGGER, "gear_sets", false, false);
    }

    public <T extends Predicate<GearSet>> GearSet getRandomSet(RandomSource rand, float luck, @Nullable List<GearSet.SetPredicate> armorSets) {
        if (armorSets == null || armorSets.isEmpty()) {
            return (GearSet)this.getRandomItem(rand, luck);
        }
        List valid = this.registry.values().stream().filter(e -> {
            for (Predicate f : armorSets) {
                if (!f.test(e)) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        if (valid.isEmpty()) {
            Placebo.LOGGER.error("Failed to locate any gear sets matching the following predicates: ");
            armorSets.forEach(s -> Placebo.LOGGER.error(s.toString()));
            return (GearSet)this.getRandomItem(rand, luck);
        }
        ArrayList list = new ArrayList(valid.size());
        valid.stream().map(l -> l.wrap(luck)).forEach(list::add);
        return WeightedRandom.m_216822_((RandomSource)rand, list).map(WeightedEntry.Wrapper::m_146310_).orElse(null);
    }

    @Override
    protected void registerBuiltinCodecs() {
        this.registerDefaultCodec(new ResourceLocation("placebo", "gear_set"), GearSet.CODEC);
    }
}

