/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.client.gui;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.satisfy.candlelight.util.CandlelightIdentifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public abstract class NoteGui
extends Screen {
    public static final ResourceLocation NOTE_TEXTURE = new CandlelightIdentifier("textures/gui/note_paper_gui.png");
    private static final Component EDIT_TITLE_TEXT = Component.m_237113_((String)"Enter Note Title");
    private static final Component FINALIZE_WARNING_TEXT = Component.m_237115_((String)"book.finalizeWarning");
    private static final FormattedCharSequence BLACK_CURSOR_TEXT = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.BLACK));
    private static final FormattedCharSequence GRAY_CURSOR_TEXT = FormattedCharSequence.m_13714_((String)"_", (Style)Style.f_131099_.m_131140_(ChatFormatting.GRAY));
    protected final Player player;
    protected final ItemStack itemStack;
    private final List<String> text = Lists.newArrayList();
    private final Component signedByText;
    protected boolean dirty;
    private boolean signing;
    private int frameTick;
    private String title = "";
    private final TextFieldHelper noteTitleSelectionManager = new TextFieldHelper(() -> this.title, title -> {
        this.title = title;
    }, this::getClipboard, this::setClipboard, string -> string.length() < 16);
    private long lastClickTime;
    private int lastClickIndex = -1;
    private Button doneButton;
    private Button signButton;
    private Button finalizeButton;
    private Button cancelButton;
    @Nullable
    private DisplayCache pageContent;
    private final TextFieldHelper currentPageSelectionManager = new TextFieldHelper(this::getCurrentDisplayCache, this::setDisplayCache, this::getClipboard, this::setClipboard, string -> string.length() < 1024 && this.f_96547_.m_92920_(string, 114) <= 128);

    public NoteGui(Player player, ItemStack itemStack) {
        super(GameNarrator.f_93310_);
        this.pageContent = DisplayCache.EMPTY;
        this.player = player;
        this.itemStack = itemStack;
        CompoundTag nbtCompound = itemStack.m_41783_();
        if (nbtCompound != null) {
            List<String> string2 = this.text;
            Objects.requireNonNull(string2);
            this.loadPages(nbtCompound, string2::add);
        }
        if (this.text.isEmpty()) {
            this.text.add("");
        }
        this.signedByText = Component.m_237110_((String)"book.byAuthor", (Object[])new Object[]{player.m_7755_()}).m_130940_(ChatFormatting.DARK_GRAY);
    }

    static int getLineFromOffset(int[] lineStarts, int position) {
        int i = Arrays.binarySearch(lineStarts, position);
        return i < 0 ? -(i + 2) : i;
    }

    static int findLineFromPos(int[] is, int i) {
        int j = Arrays.binarySearch(is, i);
        return j < 0 ? -(j + 2) : j;
    }

    protected void m_7856_() {
        this.invalidateDisplayCache();
        this.signButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"book.signButton"), button -> {
            this.signing = true;
            this.updateButtons();
        }).m_252987_(this.f_96543_ / 2 - 100, 196, 98, 20).m_253136_());
        this.doneButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(null);
            this.finalizeNote(false);
        }).m_252987_(this.f_96543_ / 2 + 2, 196, 98, 20).m_253136_());
        this.finalizeButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"book.finalizeButton"), button -> {
            if (this.signing) {
                this.finalizeNote(true);
                assert (this.f_96541_ != null);
                this.f_96541_.m_91152_(null);
            }
        }).m_252987_(this.f_96543_ / 2 - 100, 196, 98, 20).m_253136_());
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> {
            if (this.signing) {
                this.signing = false;
            }
            this.updateButtons();
        }).m_252987_(this.f_96543_ / 2 + 2, 196, 98, 20).m_253136_());
        this.updateButtons();
    }

    public void loadPages(CompoundTag compoundTag, Consumer<String> consumer) {
        IntFunction<String> intFunction;
        ListTag listTag = compoundTag.m_128437_("text", 8).m_6426_();
        if (Minecraft.m_91087_().m_167974_() && compoundTag.m_128425_("filtered_pages", 10)) {
            CompoundTag compoundTag2 = compoundTag.m_128469_("filtered_pages");
            intFunction = i -> {
                String string = String.valueOf(i);
                return compoundTag2.m_128441_(string) ? compoundTag2.m_128461_(string) : listTag.m_128778_(i);
            };
        } else {
            intFunction = arg_0 -> ((ListTag)listTag).m_128778_(arg_0);
        }
        for (int i2 = 0; i2 < listTag.size(); ++i2) {
            consumer.accept(intFunction.apply(i2));
        }
    }

    protected void removeEmptyPages() {
        ListIterator<String> listIterator = this.text.listIterator(this.text.size());
        while (listIterator.hasPrevious() && listIterator.previous().isEmpty()) {
            listIterator.remove();
        }
    }

    protected abstract void finalizeNote(boolean var1);

    protected void writeNbtData(boolean signNote) {
        ListTag nbtList = new ListTag();
        Stream<StringTag> nbts = this.text.stream().map(StringTag::m_129297_);
        Objects.requireNonNull(nbtList);
        nbts.forEach(arg_0 -> nbtList.add(arg_0));
        if (!this.text.isEmpty()) {
            this.itemStack.m_41700_("text", (Tag)nbtList);
        }
        if (signNote) {
            this.itemStack.m_41700_("author", (Tag)StringTag.m_129297_((String)this.player.m_36316_().getName()));
            this.itemStack.m_41700_("title", (Tag)StringTag.m_129297_((String)this.title.trim()));
        }
    }

    private String getClipboard() {
        return this.f_96541_ != null ? TextFieldHelper.m_95169_((Minecraft)this.f_96541_) : "";
    }

    private void setClipboard(String clipboard) {
        if (this.f_96541_ != null) {
            TextFieldHelper.m_95155_((Minecraft)this.f_96541_, (String)clipboard);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ++this.frameTick;
    }

    private void updateButtons() {
        this.doneButton.f_93624_ = !this.signing;
        this.signButton.f_93624_ = !this.signing;
        this.cancelButton.f_93624_ = this.signing;
        this.finalizeButton.f_93624_ = this.signing;
        this.finalizeButton.f_93623_ = !this.title.trim().isEmpty();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.signing) {
            return this.keyPressedSignMode(keyCode);
        }
        boolean bl = this.keyPressedEditMode(keyCode);
        if (bl) {
            this.invalidateDisplayCache();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (super.m_5534_(chr, modifiers)) {
            return true;
        }
        if (this.signing) {
            boolean bl = this.noteTitleSelectionManager.m_95143_(chr);
            if (bl) {
                this.updateButtons();
                this.dirty = true;
                return true;
            }
            return false;
        }
        if (SharedConstants.m_136188_((char)chr)) {
            this.currentPageSelectionManager.m_95158_(Character.toString(chr));
            this.invalidateDisplayCache();
            return true;
        }
        return false;
    }

    private boolean keyPressedEditMode(int keyCode) {
        if (Screen.m_96634_((int)keyCode)) {
            this.currentPageSelectionManager.m_95188_();
            return true;
        }
        if (Screen.m_96632_((int)keyCode)) {
            this.currentPageSelectionManager.m_95178_();
            return true;
        }
        if (Screen.m_96630_((int)keyCode)) {
            this.currentPageSelectionManager.m_95165_();
            return true;
        }
        if (Screen.m_96628_((int)keyCode)) {
            this.currentPageSelectionManager.m_95142_();
            return true;
        }
        TextFieldHelper.CursorStep selectionType = Screen.m_96637_() ? TextFieldHelper.CursorStep.WORD : TextFieldHelper.CursorStep.CHARACTER;
        switch (keyCode) {
            case 257: 
            case 335: {
                this.currentPageSelectionManager.m_95158_("\n");
                return true;
            }
            case 259: {
                this.currentPageSelectionManager.m_232572_(-1, selectionType);
                return true;
            }
            case 261: {
                this.currentPageSelectionManager.m_232572_(1, selectionType);
                return true;
            }
            case 262: {
                this.currentPageSelectionManager.m_232575_(1, Screen.m_96638_(), selectionType);
                return true;
            }
            case 263: {
                this.currentPageSelectionManager.m_232575_(-1, Screen.m_96638_(), selectionType);
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.moveToLineStart();
                return true;
            }
            case 269: {
                this.moveToLineEnd();
                return true;
            }
        }
        return false;
    }

    private void moveUpLine() {
        this.moveVertically(-1);
    }

    private void moveDownLine() {
        this.moveVertically(1);
    }

    private void moveVertically(int lines) {
        int i = this.currentPageSelectionManager.m_95194_();
        int j = this.getDisplayCache().changeLine(i, lines);
        this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int i) {
        int j = this.currentPageSelectionManager.m_95194_();
        int k = this.getDisplayCache().changeLine(j, i);
        this.currentPageSelectionManager.m_95179_(k, Screen.m_96638_());
    }

    private void moveToLineStart() {
        if (Screen.m_96637_()) {
            this.currentPageSelectionManager.m_95176_(Screen.m_96638_());
        } else {
            int i = this.currentPageSelectionManager.m_95194_();
            int j = this.getDisplayCache().findLineStart(i);
            this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
        }
    }

    private void moveToLineEnd() {
        if (Screen.m_96637_()) {
            this.currentPageSelectionManager.m_95186_(Screen.m_96638_());
        } else {
            DisplayCache pageContent = this.getDisplayCache();
            int i = this.currentPageSelectionManager.m_95194_();
            int j = pageContent.findLineEnd(i);
            this.currentPageSelectionManager.m_95179_(j, Screen.m_96638_());
        }
    }

    private boolean keyPressedSignMode(int keyCode) {
        switch (keyCode) {
            case 257: 
            case 335: {
                if (!this.title.isEmpty()) {
                    this.finalizeNote(true);
                    if (this.f_96541_ != null) {
                        this.f_96541_.m_91152_(null);
                    }
                }
                return true;
            }
            case 259: {
                this.noteTitleSelectionManager.m_95189_(-1);
                this.updateButtons();
                this.dirty = true;
                return true;
            }
        }
        return false;
    }

    private String getCurrentDisplayCache() {
        return !this.text.isEmpty() ? this.text.get(0) : "";
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        this.m_7522_(null);
        int x = (this.f_96543_ - 192) / 2;
        guiGraphics.m_280218_(NOTE_TEXTURE, x, 2, 0, 0, 192, 192);
        if (this.signing) {
            boolean bl = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence orderedText = FormattedCharSequence.m_13696_((FormattedCharSequence)FormattedCharSequence.m_13714_((String)this.title, (Style)Style.f_131099_), (FormattedCharSequence)(bl ? BLACK_CURSOR_TEXT : GRAY_CURSOR_TEXT));
            int k = this.f_96547_.m_92852_((FormattedText)EDIT_TITLE_TEXT);
            guiGraphics.m_280614_(this.f_96547_, EDIT_TITLE_TEXT, x + 36 + (114 - k) / 2, 34, 0, false);
            int l = this.f_96547_.m_92724_(orderedText);
            guiGraphics.m_280648_(this.f_96547_, orderedText, x + 36 + (114 - l) / 2, 50, 0);
            int m = this.f_96547_.m_92852_((FormattedText)this.signedByText);
            guiGraphics.m_280430_(this.f_96547_, this.signedByText, x + 36 + (114 - m) / 2, 60, 0);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)FINALIZE_WARNING_TEXT, x + 36, 82, 114, 0);
        } else {
            DisplayCache displayCache = this.getDisplayCache();
            for (LineInfo line : displayCache.lines) {
                guiGraphics.m_280614_(this.f_96547_, line.asComponent, line.x, line.y, -16777216, false);
            }
            this.renderHighlight(guiGraphics, displayCache.selection);
            this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    private void renderCursor(GuiGraphics guiGraphics, Pos2i pos2i, boolean bl) {
        if (this.frameTick / 6 % 2 == 0) {
            pos2i = this.convertLocalToScreen(pos2i);
            if (!bl) {
                int var10001 = pos2i.x;
                int var10002 = pos2i.y - 1;
                int var10003 = pos2i.x + 1;
                int var10004 = pos2i.y;
                Objects.requireNonNull(this.f_96547_);
                guiGraphics.m_280509_(var10001, var10002, var10003, var10004 + 9, -16777216);
            } else {
                guiGraphics.m_280056_(this.f_96547_, "_", pos2i.x, pos2i.y, 0, false);
            }
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, Rect2i[] rect2is) {
        int var4 = rect2is.length;
        for (Rect2i rect2i : rect2is) {
            int i = rect2i.m_110085_();
            int j = rect2i.m_110086_();
            int k = i + rect2i.m_110090_();
            int l = j + rect2i.m_110091_();
            guiGraphics.m_285944_(RenderType.m_285783_(), i, j, k, l, -16776961);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i pos2i) {
        return new Pos2i(pos2i.x - (this.f_96543_ - 192) / 2 - 36, pos2i.y - 32);
    }

    private Position absolutePositionToScreenPosition(Position position) {
        return new Position(position.x + (this.f_96543_ - 192) / 2 + 36, position.y + 32);
    }

    private Pos2i convertLocalToScreen(Pos2i pos2i) {
        return new Pos2i(pos2i.x + (this.f_96543_ - 192) / 2 + 36, pos2i.y + 32);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!super.m_6375_(mouseX, mouseY, button) && button == 0) {
            long l = Util.m_137550_();
            DisplayCache pageContent = this.getDisplayCache();
            int i = pageContent.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (i >= 0) {
                if (i == this.lastClickIndex && l - this.lastClickTime < 250L) {
                    if (!this.currentPageSelectionManager.m_95198_()) {
                        this.selectCurrentWord(i);
                    } else {
                        this.currentPageSelectionManager.m_95188_();
                    }
                } else {
                    this.currentPageSelectionManager.m_95179_(i, Screen.m_96638_());
                }
                this.invalidateDisplayCache();
            }
            this.lastClickIndex = i;
            this.lastClickTime = l;
        }
        return true;
    }

    private void selectCurrentWord(int cursor) {
        String string = this.getCurrentDisplayCache();
        this.currentPageSelectionManager.m_95147_(StringSplitter.m_92355_((String)string, (int)-1, (int)cursor, (boolean)false), StringSplitter.m_92355_((String)string, (int)1, (int)cursor, (boolean)false));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (!super.m_7979_(mouseX, mouseY, button, deltaX, deltaY) && button == 0) {
            DisplayCache pageContent = this.getDisplayCache();
            int i = pageContent.getIndexAtPosition(this.f_96547_, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            this.currentPageSelectionManager.m_95179_(i, true);
            this.invalidateDisplayCache();
        }
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (this.pageContent == null) {
            this.pageContent = this.createDisplayCache();
        }
        return this.pageContent;
    }

    private void setDisplayCache(String newContent) {
        if (!this.text.isEmpty()) {
            this.text.set(0, newContent);
            this.dirty = true;
            this.invalidateDisplayCache();
        }
    }

    private void invalidateDisplayCache() {
        this.pageContent = null;
    }

    private DisplayCache createDisplayCache() {
        int l;
        Pos2i position;
        boolean bl;
        String string = this.getCurrentDisplayCache();
        if (string.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.currentPageSelectionManager.m_95194_();
        int j = this.currentPageSelectionManager.m_95197_();
        ArrayList intList = new ArrayList();
        ArrayList list = new ArrayList();
        MutableInt mutableInt = new MutableInt();
        MutableBoolean mutableBoolean = new MutableBoolean();
        StringSplitter textHandler = this.f_96547_.m_92865_();
        textHandler.m_92364_(string, 114, Style.f_131099_, true, (style, start, end) -> {
            int h = mutableInt.getAndIncrement();
            String substring = string.substring(start, end);
            mutableBoolean.setValue(substring.endsWith("\n"));
            String string2 = StringUtils.stripEnd((String)substring, (String)" \n");
            Objects.requireNonNull(this.f_96547_);
            int b = h * 9;
            Position position = this.absolutePositionToScreenPosition(new Position(0, b));
            intList.add(start);
            list.add(new LineInfo(style, string2, position.x, position.y));
        });
        int[] is = intList.stream().mapToInt(Integer::intValue).toArray();
        boolean bl2 = bl = i == string.length();
        if (bl && mutableBoolean.isTrue()) {
            int var10003 = list.size();
            Objects.requireNonNull(this.f_96547_);
            position = new Pos2i(0, var10003 * 9);
        } else {
            int k = NoteGui.getLineFromOffset(is, i);
            l = this.f_96547_.m_92895_(string.substring(is[k], i));
            Objects.requireNonNull(this.f_96547_);
            position = new Pos2i(l, k * 9);
        }
        ArrayList<Rect2i> list2 = new ArrayList<Rect2i>();
        if (i != j) {
            int o;
            l = Math.min(i, j);
            int m = Math.max(i, j);
            int n = NoteGui.getLineFromOffset(is, l);
            if (n == (o = NoteGui.getLineFromOffset(is, m))) {
                Objects.requireNonNull(this.f_96547_);
                int p = n * 9;
                int q = is[n];
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, m, p, q));
            } else {
                int p = n + 1 > is.length ? string.length() : is[n + 1];
                Objects.requireNonNull(this.f_96547_);
                list2.add(this.getLineSelectionRectangle(string, textHandler, l, p, n * 9, is[n]));
                for (int q = n + 1; q < o; ++q) {
                    Objects.requireNonNull(this.f_96547_);
                    int r = q * 9;
                    String string2 = string.substring(is[q], is[q + 1]);
                    int s = (int)textHandler.m_92353_(string2);
                    Position var10002 = new Position(0, r);
                    Objects.requireNonNull(this.f_96547_);
                    list2.add(this.getRectFromCorners(var10002, new Position(s, r + 9)));
                }
                int var10004 = is[o];
                Objects.requireNonNull(this.f_96547_);
                list2.add(this.getLineSelectionRectangle(string, textHandler, var10004, m, o * 9, is[o]));
            }
        }
        return new DisplayCache(string, position, bl, is, list.toArray(new LineInfo[0]), list2.toArray(new Rect2i[0]));
    }

    private Rect2i getLineSelectionRectangle(String string, StringSplitter handler, int selectionStart, int selectionEnd, int lineY, int lineStart) {
        String string2 = string.substring(lineStart, selectionStart);
        String string3 = string.substring(lineStart, selectionEnd);
        Position position = new Position((int)handler.m_92353_(string2), lineY);
        int var10002 = (int)handler.m_92353_(string3);
        Objects.requireNonNull(this.f_96547_);
        Position position2 = new Position(var10002, lineY + 9);
        return this.getRectFromCorners(position, position2);
    }

    private Rect2i getRectFromCorners(Position start, Position end) {
        Position position = this.absolutePositionToScreenPosition(start);
        Position position2 = this.absolutePositionToScreenPosition(end);
        int i = Math.min(position.x, position2.x);
        int j = Math.max(position.x, position2.x);
        int k = Math.min(position.y, position2.y);
        int l = Math.max(position.y, position2.y);
        return new Rect2i(i, k, j - i, l - k);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(Style.f_131099_, "", 0, 0)}, new Rect2i[0]);
        final Pos2i cursor;
        final boolean cursorAtEnd;
        final LineInfo[] lines;
        final Rect2i[] selection;
        private final String fullText;
        private final int[] lineStarts;

        public DisplayCache(String string, Pos2i pos2i, boolean bl, int[] is, LineInfo[] lineInfos, Rect2i[] rect2is) {
            this.fullText = string;
            this.cursor = pos2i;
            this.cursorAtEnd = bl;
            this.lineStarts = is;
            this.lines = lineInfos;
            this.selection = rect2is;
        }

        public int getIndexAtPosition(Font font, Pos2i pos2i) {
            int var10000 = pos2i.y;
            Objects.requireNonNull(font);
            int i = var10000 / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo lineInfo = this.lines[i];
            return this.lineStarts[i] + font.m_92865_().m_92360_(lineInfo.contents, pos2i.x, lineInfo.style);
        }

        public int changeLine(int i, int j) {
            int o;
            int k = NoteGui.findLineFromPos(this.lineStarts, i);
            int l = k + j;
            if (l >= 0 && l < this.lineStarts.length) {
                int m = i - this.lineStarts[k];
                int n = this.lines[l].contents.length();
                o = this.lineStarts[l] + Math.min(m, n);
            } else {
                o = i;
            }
            return o;
        }

        public int findLineStart(int i) {
            int j = NoteGui.findLineFromPos(this.lineStarts, i);
            return this.lineStarts[j];
        }

        public int findLineEnd(int i) {
            int j = NoteGui.findLineFromPos(this.lineStarts, i);
            return this.lineStarts[j] + this.lines[j].contents.length();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class LineInfo {
        final Style style;
        final String contents;
        final Component asComponent;
        final int x;
        final int y;

        public LineInfo(Style style, String string, int i, int j) {
            this.style = style;
            this.contents = string;
            this.x = i;
            this.y = j;
            this.asComponent = Component.m_237113_((String)string).m_6270_(style);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class Pos2i {
        public final int x;
        public final int y;

        Pos2i(int i, int j) {
            this.x = i;
            this.y = j;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private record Position(int x, int y) {
    }
}

