/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.candlelight.block;

import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.block.entity.StorageBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.candlelight.registry.StorageTypeRegistry;
import net.satisfy.candlelight.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JewelryBoxBlock
extends StorageBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0);

    public JewelryBoxBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && blockEntity instanceof StorageBlockEntity) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)OPEN) == false)), 3);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity shelfBlockEntity = (StorageBlockEntity)blockEntity;
            Optional optional = Util.getRelativeHitCoordinatesForBlockFace((BlockHitResult)hit, (Direction)((Direction)state.m_61143_((Property)FACING)), (Direction[])this.unAllowedDirections());
            if (optional.isEmpty()) {
                return InteractionResult.PASS;
            }
            Tuple ff = (Tuple)optional.get();
            int i = this.getSection((Float)ff.m_14418_(), (Float)ff.m_14419_());
            if (i == Integer.MIN_VALUE) {
                return InteractionResult.PASS;
            }
            ItemStack stack = player.m_21120_(hand);
            if (!((ItemStack)shelfBlockEntity.getInventory().get(i)).m_41619_()) {
                this.remove(world, pos, player, shelfBlockEntity, i);
                return InteractionResult.m_19078_((boolean)false);
            }
            if (!stack.m_41619_() && this.canInsertStack(stack)) {
                this.add(world, pos, player, shelfBlockEntity, stack, i);
                return InteractionResult.m_19078_((boolean)false);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public int size() {
        return 1;
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.JEWELRY_BOX;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[0];
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_204117_(TagRegistry.RINGS);
    }

    public int getSection(Float f, Float y) {
        float oneS = 1.0f;
        int nSection = (int)(f.floatValue() / oneS);
        return -nSection;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN});
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.candlelight.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

