/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.server.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.IOException;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.server.command.PaintingInput;
import me.dantaeusb.zetter.server.command.PaintingLookupArgument;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class ExportServerCommand {
    private static final DynamicCommandExceptionType ERROR_PAINTING_NOT_FOUND = new DynamicCommandExceptionType(code -> Component.m_237110_((String)"console.zetter.error.painting_not_found", (Object[])new Object[]{code}));
    private static final DynamicCommandExceptionType ERROR_CANNOT_CREATE_FILE = new DynamicCommandExceptionType(code -> Component.m_237110_((String)"console.zetter.error.file_write_error", (Object[])new Object[]{code}));

    static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"export").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"server").then(Commands.m_82129_((String)"painting", (ArgumentType)PaintingLookupArgument.painting()).executes(ctx -> ExportServerCommand.execute((CommandSourceStack)ctx.getSource(), (Player)((CommandSourceStack)ctx.getSource()).m_230896_(), (Level)((CommandSourceStack)ctx.getSource()).m_81372_(), PaintingLookupArgument.getPaintingInput(ctx, "painting")))));
    }

    private static int execute(CommandSourceStack source, Player player, Level level, PaintingInput paintingInput) throws CommandRuntimeException, CommandSyntaxException {
        if (!paintingInput.hasPaintingData(level)) {
            throw ERROR_PAINTING_NOT_FOUND.create((Object)paintingInput.getPaintingCode());
        }
        try {
            Helper.exportPainting(level.m_7654_().m_6237_(), paintingInput.getPaintingCode(), paintingInput.getPaintingData());
        }
        catch (IOException e) {
            throw ERROR_CANNOT_CREATE_FILE.create((Object)e.getMessage());
        }
        return 1;
    }
}

