/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import me.dantaeusb.zetter.network.packet.CCanvasRequestPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasRequestViewPacket
extends CCanvasRequestPacket {
    private final InteractionHand hand;

    public CCanvasRequestViewPacket(String canvasName, InteractionHand hand) {
        super(canvasName);
        this.hand = hand;
    }

    public static CCanvasRequestViewPacket readPacketData(FriendlyByteBuf buf) {
        String canvasName = buf.m_130136_(64);
        byte handCode = buf.readByte();
        InteractionHand hand = InteractionHand.values()[handCode];
        return new CCanvasRequestViewPacket(canvasName, hand);
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130072_(this.canvasName, 64);
        buf.writeByte(this.hand.ordinal());
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public static void handle(CCanvasRequestViewPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CRequestSyncPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCanvasViewRequest(packetIn, sendingPlayer));
    }
}

