/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasHistoryActionPacket {
    public final int easelEntityId;
    public final int actionId;
    public final boolean canceled;

    public CCanvasHistoryActionPacket(int easelEntityId, int actionId, boolean canceled) {
        this.easelEntityId = easelEntityId;
        this.actionId = actionId;
        this.canceled = canceled;
    }

    public static CCanvasHistoryActionPacket readPacketData(FriendlyByteBuf buffer) {
        int easelEntityId = buffer.readInt();
        int actionId = buffer.readInt();
        boolean canceled = buffer.readBoolean();
        return new CCanvasHistoryActionPacket(easelEntityId, actionId, canceled);
    }

    public void writePacketData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.easelEntityId);
        buffer.writeInt(this.actionId);
        buffer.writeBoolean(this.canceled);
    }

    public static void handle(CCanvasHistoryActionPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CCanvasHistoryPacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processCanvasHistory(packetIn, sendingPlayer));
    }
}

