/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.client.gui.easel.TabsWidget;
import me.dantaeusb.zetter.client.painting.ClientPaintingToolParameters;
import me.dantaeusb.zetter.core.EaselStateListener;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterContainerMenus;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.entity.item.EaselEntity;
import me.dantaeusb.zetter.entity.item.container.EaselContainer;
import me.dantaeusb.zetter.entity.item.state.EaselState;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.PaletteItem;
import me.dantaeusb.zetter.network.packet.CPaletteUpdatePacket;
import me.dantaeusb.zetter.network.packet.SEaselMenuCreatePacket;
import me.dantaeusb.zetter.painting.Tools;
import me.dantaeusb.zetter.painting.parameters.AbstractToolParameters;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class EaselMenu
extends AbstractContainerMenu
implements EaselStateListener,
ItemStackHandlerListener {
    private final Player player;
    private final EaselContainer container;
    private final EaselState state;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    public static final int PLAYER_INVENTORY_XPOS = 38;
    public static final int PLAYER_INVENTORY_YPOS = 156;
    public static final int TOTAL_SLOT_COUNT = 38;
    private TabsWidget.Tab currentTab = TabsWidget.Tab.COLOR;
    private Tools currentTool = Tools.PENCIL;
    private boolean canUndo = false;
    private boolean canRedo = false;
    private final List<Consumer<AbstractToolParameters>> toolUpdateListeners = new ArrayList<Consumer<AbstractToolParameters>>();
    private final List<Consumer<Integer>> colorUpdateListeners = new ArrayList<Consumer<Integer>>();
    public static final int PALETTE_SLOTS = PaletteItem.PALETTE_SIZE;
    private int currentPaletteSlot = 0;
    public static final int MIN_SCALE = 1;
    public static final int MAX_SCALE = 3;
    private int canvasOffsetX = 0;
    private int canvasOffsetY = 0;
    private int canvasScaleFactor = 3;

    public EaselMenu(int windowID, Inventory invPlayer, EaselContainer easelContainer, EaselState stateHandler) {
        super((MenuType)ZetterContainerMenus.EASEL.get(), windowID);
        this.player = invPlayer.f_35978_;
        this.container = easelContainer;
        this.state = stateHandler;
        int CANVAS_SLOT_X = 180;
        int CANVAS_SLOT_Y = 9;
        int PALETTE_SLOT_X = 180;
        int PALETTE_SLOT_Y = 132;
        int SLOT_X_SPACING = 18;
        int SLOT_Y_SPACING = 18;
        int HOTBAR_XPOS = 38;
        int HOTBAR_YPOS = 214;
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.container, 0, 180, 9){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ZetterItems.CANVAS.get();
            }
        });
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.container, 1, 180, 132){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() == ZetterItems.PALETTE.get();
            }
        });
        for (int y = 0; y < 3; ++y) {
            int slotNumber;
            int x;
            for (x = 0; x < 9; ++x) {
                slotNumber = 9 + y * 9 + x;
                int xpos = 38 + x * 18;
                int ypos = 156 + y * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, xpos, ypos){

                    public boolean m_6659_() {
                        if (EaselMenu.this.getCurrentTab() == TabsWidget.Tab.INVENTORY) {
                            return super.m_6659_();
                        }
                        return false;
                    }
                });
            }
            for (x = 0; x < 9; ++x) {
                slotNumber = x;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, 38 + 18 * x, 214){

                    public boolean m_6659_() {
                        if (EaselMenu.this.getCurrentTab() == TabsWidget.Tab.INVENTORY) {
                            return super.m_6659_();
                        }
                        return false;
                    }
                });
            }
        }
        this.state.addListener(this);
        this.container.addListener(this);
        if (this.player.m_7578_()) {
            this.state.addPlayer(this.player);
        }
    }

    public static EaselMenu createMenuServerSide(int windowID, Inventory playerInventory, EaselContainer easelContainer, EaselState stateHandler) {
        EaselMenu easelMenu = new EaselMenu(windowID, playerInventory, easelContainer, stateHandler);
        return easelMenu;
    }

    public static EaselMenu createMenuClientSide(int windowID, Inventory playerInventory, FriendlyByteBuf networkBuffer) {
        SEaselMenuCreatePacket createPacket = SEaselMenuCreatePacket.readPacketData(networkBuffer);
        EaselEntity easelEntity = (EaselEntity)playerInventory.f_35978_.m_9236_().m_6815_(createPacket.easelEntityId);
        assert (easelEntity != null);
        EaselContainer easelContainer = easelEntity.getEaselContainer();
        EaselState stateHandler = easelEntity.getStateHandler();
        easelContainer.handleCanvasChange(createPacket.canvasCode);
        return new EaselMenu(windowID, playerInventory, easelContainer, stateHandler);
    }

    public void resetCanvasPositioning() {
        CanvasData canvasData = this.getCanvasData();
        if (canvasData != null) {
            int wScale = 128 / canvasData.getWidth();
            int hScale = 128 / canvasData.getHeight();
            int scaleFactor = Math.min(hScale, wScale) / 2;
            scaleFactor = Math.min(Math.max(scaleFactor, 1), 3);
            int scaledWidth = canvasData.getWidth() * scaleFactor * 2;
            int scaledHeight = canvasData.getHeight() * scaleFactor * 2;
            int offsetX = (128 - scaledWidth) / 2;
            int offsetY = (128 - scaledHeight) / 2;
            this.canvasOffsetX = offsetX;
            this.canvasOffsetY = offsetY;
            this.canvasScaleFactor = scaleFactor;
        } else {
            this.canvasOffsetX = 0;
            this.canvasOffsetY = 0;
            this.canvasScaleFactor = 3;
        }
    }

    public int getCurrentPaletteSlot() {
        return this.currentPaletteSlot;
    }

    public void setCurrentPaletteSlot(int slotIndex) {
        this.currentPaletteSlot = slotIndex;
        for (Consumer<Integer> listener : this.colorUpdateListeners) {
            listener.accept(this.getCurrentColor());
        }
    }

    public Tools getCurrentTool() {
        return this.currentTool;
    }

    public void setCurrentTool(Tools tool) {
        this.currentTool = tool;
        for (Consumer<AbstractToolParameters> listener : this.toolUpdateListeners) {
            listener.accept(this.getCurrentToolParameters());
        }
    }

    public void useTool(float posX, float posY) {
        this.state.useTool(this.player, this.currentTool, posX, posY, this.getCurrentColor(), this.getCurrentToolParameters());
    }

    public AbstractToolParameters getCurrentToolParameters() {
        return ClientPaintingToolParameters.getInstance().getToolParameters(this.currentTool);
    }

    public int getCurrentColor() {
        return this.getPaletteColor(this.getCurrentPaletteSlot());
    }

    public EaselContainer getContainer() {
        return this.container;
    }

    public EaselState getState() {
        return this.state;
    }

    @Override
    public void containerChanged(ItemStackHandler container, int slot) {
        if (slot == 1) {
            this.notifyColorUpdateListeners();
        } else if (slot == 0 && this.player.m_7578_()) {
            this.resetCanvasPositioning();
        }
    }

    public void addToolUpdateListener(Consumer<AbstractToolParameters> subscriber) {
        if (this.toolUpdateListeners.contains(subscriber)) {
            return;
        }
        this.toolUpdateListeners.add(subscriber);
        subscriber.accept(this.getCurrentToolParameters());
    }

    public void removeToolUpdateListener(Consumer<AbstractToolParameters> subscriber) {
        if (!this.toolUpdateListeners.contains(subscriber)) {
            return;
        }
        this.toolUpdateListeners.remove(subscriber);
    }

    public void addColorUpdateListener(Consumer<Integer> subscriber) {
        if (this.colorUpdateListeners.contains(subscriber)) {
            return;
        }
        this.colorUpdateListeners.add(subscriber);
    }

    public void removeColorUpdateListener(Consumer<Integer> subscriber) {
        if (!this.colorUpdateListeners.contains(subscriber)) {
            return;
        }
        this.colorUpdateListeners.remove(subscriber);
    }

    public void notifyColorUpdateListeners() {
        for (Consumer<Integer> listener : this.colorUpdateListeners) {
            listener.accept(this.getCurrentColor());
        }
    }

    @Override
    public void stateCanvasInitializationStart(EaselState state) {
        this.m_150443_();
    }

    @Override
    public void stateCanvasInitializationEnd(EaselState state) {
        this.m_150444_();
    }

    @Override
    public void stateChanged(EaselState state) {
        this.updateCanHistory();
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public boolean canRedo() {
        return this.canRedo;
    }

    public boolean undo() {
        if (!this.canUndo) {
            return false;
        }
        boolean result = this.state.undo();
        return result;
    }

    public boolean redo() {
        if (!this.canRedo) {
            return false;
        }
        boolean result = this.state.redo();
        return result;
    }

    private void updateCanHistory() {
        this.canUndo = this.state.canUndo();
        this.canRedo = this.state.canRedo();
    }

    public boolean handleCanvasSync(String canvasCode, CanvasData canvasData, long timestamp) {
        if (this.container.getCanvas() == null || !this.container.getCanvas().code.equals(canvasCode)) {
            this.container.handleCanvasChange(canvasCode);
            if (this.getCanvasData() != null) {
                this.updateCanvasOffset(this.canvasOffsetX, this.canvasOffsetY);
            }
            return false;
        }
        return true;
    }

    public int getPaletteColor(int paletteSlot) {
        ItemStack paletteStack = this.container.getPaletteStack();
        if (paletteStack.m_41619_()) {
            return -16777216;
        }
        return PaletteItem.getPaletteColors(paletteStack)[paletteSlot];
    }

    public void setCurrentTab(TabsWidget.Tab tab) {
        this.currentTab = tab;
    }

    public TabsWidget.Tab getCurrentTab() {
        return this.currentTab;
    }

    public void setPaletteColor(int color) {
        this.setPaletteColor(color, this.currentPaletteSlot);
    }

    public void setPaletteColor(int color, int slot) {
        ItemStack paletteStack = this.container.getPaletteStack();
        if (paletteStack.m_41619_()) {
            return;
        }
        PaletteItem.updatePaletteColor(paletteStack, slot, color);
        this.notifyColorUpdateListeners();
        if (this.player.m_7578_()) {
            this.sendPaletteUpdatePacket();
        }
        this.container.changed();
    }

    public void sendPaletteUpdatePacket() {
        if (!this.isPaletteAvailable()) {
            return;
        }
        CPaletteUpdatePacket paletteUpdatePacket = new CPaletteUpdatePacket(this.currentPaletteSlot, this.getCurrentColor());
        Zetter.LOG.debug("Sending Palette Update: " + paletteUpdatePacket);
        ZetterNetwork.simpleChannel.sendToServer((Object)paletteUpdatePacket);
    }

    @Nullable
    public String getCanvasItemCode() {
        ItemStack canvasStack = this.container.getCanvasStack();
        if (canvasStack.m_41619_()) {
            return null;
        }
        return CanvasItem.getCanvasCode(canvasStack);
    }

    @Nullable
    public String getCanvasCode() {
        if (this.container.getCanvas() == null) {
            return null;
        }
        return this.container.getCanvas().code;
    }

    @Nullable
    public CanvasData getCanvasData() {
        if (this.container.getCanvas() == null) {
            return null;
        }
        return (CanvasData)((Object)this.container.getCanvas().data);
    }

    public boolean isCanvasAvailable() {
        return this.container.getCanvas() != null;
    }

    public boolean isPaletteAvailable() {
        ItemStack paletteStack = this.container.getPaletteStack();
        return !paletteStack.m_41619_();
    }

    public int getCanvasOffsetX() {
        return this.canvasOffsetX;
    }

    public int getCanvasOffsetY() {
        return this.canvasOffsetY;
    }

    public void updateCanvasOffset(int offsetX, int offsetY) {
        if (this.getCanvasData() == null) {
            return;
        }
        int width = this.getCanvasData().getWidth() * this.getCanvasScaleFactor() * 2;
        int minOffsetX = -width + 64;
        int maxOffsetX = 64;
        int height = this.getCanvasData().getHeight() * this.getCanvasScaleFactor() * 2;
        int minOffsetY = -height + 64;
        int maxOffsetY = 64;
        this.canvasOffsetX = Math.max(minOffsetX, Math.min(offsetX, 64));
        this.canvasOffsetY = Math.max(minOffsetY, Math.min(offsetY, 64));
    }

    public int getCanvasScaleFactor() {
        return this.canvasScaleFactor;
    }

    public boolean canIncreaseCanvasScale() {
        return this.getCanvasData() != null && this.canvasScaleFactor < 3;
    }

    public boolean canDecreaseCanvasScale() {
        return this.getCanvasData() != null && this.canvasScaleFactor > 1;
    }

    public boolean increaseCanvasScale() {
        if (!this.canIncreaseCanvasScale()) {
            return false;
        }
        assert (this.getCanvasData() != null);
        ++this.canvasScaleFactor;
        this.canvasOffsetX -= this.getCanvasData().getWidth();
        this.canvasOffsetY -= this.getCanvasData().getHeight();
        return true;
    }

    public boolean decreaseCanvasScale() {
        if (!this.canDecreaseCanvasScale()) {
            return false;
        }
        assert (this.getCanvasData() != null);
        --this.canvasScaleFactor;
        this.canvasOffsetX += this.getCanvasData().getWidth();
        this.canvasOffsetY += this.getCanvasData().getHeight();
        return true;
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.state.removeListener(this);
        this.container.removeListener(this);
        if (this.player.m_7578_()) {
            this.state.removePlayer(player);
        }
    }

    public ItemStack m_7648_(@Nonnull Player playerIn, int sourceSlotIndex) {
        ItemStack outStack = ItemStack.f_41583_;
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.m_6657_()) {
            ItemStack sourceStack = sourceSlot.m_7993_();
            outStack = sourceStack.m_41777_();
            if (sourceSlotIndex <= 1) {
                if (!this.m_38903_(sourceStack, 2, 38, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (sourceStack.m_41720_() == ZetterItems.PALETTE.get()) {
                if (!this.m_38903_(sourceStack, 0, 1, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (sourceStack.m_41720_() == ZetterItems.CANVAS.get()) {
                if (!this.m_38903_(sourceStack, 1, 2, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41619_()) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            if (sourceStack.m_41613_() == outStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
        }
        return outStack;
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.container.stillValid(player);
    }
}

