/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.ZetterCraftingRecipes;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.item.PaletteItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CopyingRecipe
extends CustomRecipe {
    private final Ingredient inputPainting;
    private final Ingredient inputCanvas;
    private final Ingredient inputPalette;

    public CopyingRecipe(ResourceLocation id, Ingredient inputPainting, Ingredient inputCanvas, Ingredient inputPalette) {
        super(id, CraftingBookCategory.MISC);
        this.inputPainting = inputPainting;
        this.inputCanvas = inputCanvas;
        this.inputPalette = inputPalette;
    }

    public String toString() {
        return "FramingRecipe [inputPainting=" + this.inputPainting + ", inputCanvas=" + this.inputCanvas + ", inputPalette=" + this.inputPalette + "]";
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        int[] canvasSize;
        ItemStack paintingStack = ItemStack.f_41583_;
        ItemStack canvasStack = ItemStack.f_41583_;
        ItemStack paletteStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (craftingInventory.m_8020_(i).m_41619_()) continue;
            if (this.inputPainting.test(craftingInventory.m_8020_(i))) {
                if (!paintingStack.m_41619_()) {
                    return false;
                }
                paintingStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (this.inputCanvas.test(craftingInventory.m_8020_(i))) {
                if (!canvasStack.m_41619_()) {
                    return false;
                }
                canvasStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (this.inputPalette.test(craftingInventory.m_8020_(i))) {
                if (!paletteStack.m_41619_()) {
                    return false;
                }
                paletteStack = craftingInventory.m_8020_(i);
                continue;
            }
            return false;
        }
        if (paintingStack.m_41619_() || canvasStack.m_41619_() || paletteStack.m_41619_()) {
            return false;
        }
        if (PaintingItem.isEmpty(paintingStack)) {
            return false;
        }
        if (!CanvasItem.isEmpty(canvasStack)) {
            return false;
        }
        int paletteDamage = paletteStack.m_41773_();
        int maxDamage = paletteStack.m_41776_() - 1;
        int newDamage = paletteDamage + CopyingRecipe.calculatePaletteDamage(paintingStack);
        if (newDamage > maxDamage) {
            return false;
        }
        int[] paintingSize = PaintingItem.getBlockSize(paintingStack);
        return Arrays.equals(paintingSize, canvasSize = CanvasItem.getBlockSize(canvasStack));
    }

    @NotNull
    public ItemStack assemble(CraftingContainer craftingInventory, RegistryAccess registryAccess) {
        int[] canvasSize;
        ItemStack paintingStack = ItemStack.f_41583_;
        ItemStack canvasStack = ItemStack.f_41583_;
        ItemStack paletteStack = ItemStack.f_41583_;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            if (this.inputPainting.test(craftingInventory.m_8020_(i))) {
                if (!paintingStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                paintingStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (this.inputCanvas.test(craftingInventory.m_8020_(i))) {
                if (!canvasStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                canvasStack = craftingInventory.m_8020_(i);
                continue;
            }
            if (!this.inputPalette.test(craftingInventory.m_8020_(i))) continue;
            if (!paletteStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            paletteStack = craftingInventory.m_8020_(i);
        }
        if (paintingStack.m_41619_() || !paintingStack.m_41782_()) {
            return ItemStack.f_41583_;
        }
        if (PaintingItem.isEmpty(paintingStack)) {
            return ItemStack.f_41583_;
        }
        if (!CanvasItem.isEmpty(canvasStack)) {
            return ItemStack.f_41583_;
        }
        int paletteDamage = paletteStack.m_41773_();
        int maxDamage = paletteStack.m_41776_() - 1;
        int newDamage = paletteDamage + CopyingRecipe.calculatePaletteDamage(paintingStack);
        if (newDamage > maxDamage) {
            return ItemStack.f_41583_;
        }
        int[] paintingSize = PaintingItem.getBlockSize(paintingStack);
        if (!Arrays.equals(paintingSize, canvasSize = CanvasItem.getBlockSize(canvasStack))) {
            return ItemStack.f_41583_;
        }
        ItemStack outStack = paintingStack.m_41777_();
        outStack.m_41764_(1);
        CompoundTag compoundTag = paintingStack.m_41783_().m_6426_();
        outStack.m_41751_(compoundTag);
        int generation = Math.min(2, PaintingItem.getGeneration(paintingStack) + 1);
        PaintingItem.setGeneration(outStack, generation);
        return outStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        ItemStack originalPaintingStack = null;
        ItemStack paletteStack = null;
        int paletteDamage = 0;
        for (int i = 0; i < remainingItems.size(); ++i) {
            CompoundTag compoundTag;
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41720_() instanceof PaintingItem) {
                Item originalPainting = stackInSlot.m_41720_();
                originalPaintingStack = new ItemStack((ItemLike)originalPainting);
                originalPaintingStack.m_41764_(1);
                compoundTag = stackInSlot.m_41783_().m_6426_();
                originalPaintingStack.m_41751_(compoundTag);
                remainingItems.set(i, (Object)originalPaintingStack);
                continue;
            }
            if (!(stackInSlot.m_41720_() instanceof PaletteItem)) continue;
            Item palette = stackInSlot.m_41720_();
            paletteDamage = stackInSlot.m_41773_();
            paletteStack = new ItemStack((ItemLike)palette);
            paletteStack.m_41764_(1);
            compoundTag = stackInSlot.m_41783_().m_6426_();
            paletteStack.m_41751_(compoundTag);
            paletteStack.m_41721_(stackInSlot.m_41773_());
            remainingItems.set(i, (Object)paletteStack);
        }
        if (originalPaintingStack != null && paletteStack != null) {
            int maxDamage = paletteStack.m_41776_() - 1;
            int newDamage = paletteDamage + CopyingRecipe.calculatePaletteDamage(originalPaintingStack);
            newDamage = Math.min(newDamage, maxDamage);
            paletteStack.m_41721_(newDamage);
        }
        return remainingItems;
    }

    private static int calculatePaletteDamage(ItemStack painting) {
        int[] paintingSize = PaintingItem.getBlockSize(painting);
        if (paintingSize == null || paintingSize.length != 2) {
            Zetter.LOG.error("Cannot find painting size to damage palette");
            return 0;
        }
        return paintingSize[0] * PaintingItem.getResolution(painting) * (paintingSize[1] * PaintingItem.getResolution(painting));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ZetterCraftingRecipes.COPYING.get();
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public static class Serializer
    implements RecipeSerializer<CopyingRecipe> {
        public CopyingRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonObject inputPaintingJson = GsonHelper.m_13930_((JsonObject)json, (String)"painting");
            Ingredient inputPainting = Ingredient.m_43917_((JsonElement)inputPaintingJson);
            JsonObject inputCanvasJson = GsonHelper.m_13930_((JsonObject)json, (String)"canvas");
            Ingredient inputCanvas = Ingredient.m_43917_((JsonElement)inputCanvasJson);
            JsonObject inputPaletteJson = GsonHelper.m_13930_((JsonObject)json, (String)"palette");
            Ingredient inputPalette = Ingredient.m_43917_((JsonElement)inputPaletteJson);
            return new CopyingRecipe(recipeId, inputPainting, inputCanvas, inputPalette);
        }

        public CopyingRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient paintingIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient canvasIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient paletteIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new CopyingRecipe(recipeId, paintingIngredient, canvasIngredient, paletteIngredient);
        }

        public void toNetwork(FriendlyByteBuf buffer, CopyingRecipe recipe) {
            recipe.inputPainting.m_43923_(buffer);
            recipe.inputCanvas.m_43923_(buffer);
            recipe.inputPalette.m_43923_(buffer);
        }
    }
}

