/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import java.util.Optional;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.entity.item.PaintingEntity;
import me.dantaeusb.zetter.item.PaintingItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class FrameItem
extends PaintingItem {
    private PaintingEntity.Materials material;
    private boolean hasPlate;

    public FrameItem(Item.Properties properties, PaintingEntity.Materials material, boolean plated) {
        super(properties);
        this.material = material;
        this.hasPlate = plated;
    }

    @Override
    public Component m_7626_(ItemStack stack) {
        if (stack.m_41782_()) {
            String paintingName = FrameItem.getCachedPaintingName(stack);
            if (StringUtil.m_14408_((String)paintingName)) {
                if (StringUtil.m_14408_((String)FrameItem.getPaintingCode(stack))) {
                    return Component.m_237115_((String)this.m_5671_(stack));
                }
                paintingName = Component.m_237115_((String)"item.zetter.painting.unnamed").getString();
            }
            if (!StringUtil.m_14408_((String)paintingName)) {
                return Component.m_237115_((String)paintingName);
            }
        }
        return Component.m_237115_((String)this.m_5671_(stack));
    }

    public PaintingEntity.Materials getMaterial() {
        return this.material;
    }

    public boolean hasPlate() {
        return this.hasPlate;
    }

    public static byte getHasPaintingPropertyOverride(ItemStack stack, @Nullable Level world, @Nullable LivingEntity livingEntity, int weirdInt) {
        EnumFrameStyle hasPainting = StringUtil.m_14408_((String)FrameItem.getPaintingCode(stack)) ? EnumFrameStyle.EMPTY : EnumFrameStyle.PAINTING;
        return hasPainting.getPropertyOverrideValue();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockPos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos facePos = blockPos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        if (player != null && !this.canPlace(player, direction, stack, facePos)) {
            return InteractionResult.FAIL;
        }
        if (StringUtil.m_14408_((String)FrameItem.getPaintingCode(stack))) {
            return InteractionResult.FAIL;
        }
        Level level = context.m_43725_();
        PaintingEntity paintingEntity = new PaintingEntity(level, facePos, direction, this.material, this.hasPlate, FrameItem.getPaintingCode(stack), FrameItem.getBlockSize(stack), FrameItem.getGeneration(stack));
        if (paintingEntity.m_7088_()) {
            if (!level.f_46443_) {
                paintingEntity.m_7084_();
                level.m_220400_((Entity)player, GameEvent.f_157810_, paintingEntity.m_20182_());
                level.m_7967_((Entity)paintingEntity);
            }
            stack.m_41774_(1);
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    protected boolean canPlace(Player playerIn, Direction directionIn, ItemStack itemStackIn, BlockPos posIn) {
        return !directionIn.m_122434_().m_122478_() && playerIn.m_36204_(posIn, directionIn, itemStackIn);
    }

    public static enum EnumFrameStyle implements StringRepresentable
    {
        EMPTY(0, "empty", "Missing painting"),
        PAINTING(1, "painting", "Framed painting");

        private final byte nbtId;
        private final String name;
        private final String description;

        private EnumFrameStyle(int nbtId, String name, String description) {
            this.nbtId = (byte)nbtId;
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public String m_7912_() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public byte getPropertyOverrideValue() {
            return this.nbtId;
        }

        public static EnumFrameStyle fromNBT(CompoundTag compoundNBT, String tagname) {
            byte hasPaintingValue = 0;
            if (compoundNBT != null && compoundNBT.m_128441_(tagname)) {
                hasPaintingValue = compoundNBT.m_128445_(tagname);
            }
            Optional<EnumFrameStyle> hasPainting = EnumFrameStyle.getEnumFromValue(hasPaintingValue);
            return hasPainting.orElse(EMPTY);
        }

        public void putIntoNBT(CompoundTag compoundNBT, String tagName) {
            compoundNBT.m_128344_(tagName, this.nbtId);
        }

        private static Optional<EnumFrameStyle> getEnumFromValue(byte ID) {
            for (EnumFrameStyle fullness : EnumFrameStyle.values()) {
                if (fullness.nbtId != ID) continue;
                return Optional.of(fullness);
            }
            return Optional.empty();
        }
    }
}

