/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.item;

import java.security.InvalidParameterException;
import java.util.List;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.core.ClientHelper;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.network.packet.CCanvasRequestViewPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CanvasItem
extends Item {
    public static final String NBT_TAG_CANVAS_CODE = "CanvasCode";
    public static final String NBT_TAG_CACHED_BLOCK_SIZE = "CachedBlockSize";
    public static final String NBT_TAG_CACHED_RESOLUTION = "CachedResolution";

    public CanvasItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (world.m_5776_()) {
            ItemStack canvas = player.m_21120_(hand);
            if (CanvasItem.isEmpty(canvas)) {
                return InteractionResultHolder.m_19096_((Object)canvas);
            }
            String canvasCode = CanvasItem.getCanvasCode(canvas);
            CanvasData canvasData = CanvasItem.getCanvasData(canvas, player.m_9236_());
            if (canvasData != null) {
                ClientHelper.openCanvasScreen(player, canvasCode, canvasData, hand);
            } else {
                CCanvasRequestViewPacket requestViewPacket = new CCanvasRequestViewPacket(canvasCode, hand);
                Zetter.LOG.debug("Sending request view packet: " + requestViewPacket);
                ZetterNetwork.simpleChannel.sendToServer((Object)requestViewPacket);
            }
        }
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6986_(itemstack, hand);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)world.m_5776_());
    }

    public Component m_7626_(ItemStack stack) {
        String canvasCode;
        if (stack.m_41782_() && !StringUtil.m_14408_((String)(canvasCode = CanvasItem.getCanvasCode(stack)))) {
            return Component.m_237115_((String)"item.zetter.canvas.painted");
        }
        return Component.m_237115_((String)"item.zetter.canvas.blank");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        String stringSize = CanvasItem.getStringSize(stack);
        if (!StringUtil.m_14408_((String)stringSize)) {
            tooltip.add((Component)Component.m_237113_((String)stringSize).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static CanvasData createEmpty(ItemStack stack, AbstractCanvasData.Resolution resolution, int widthBlock, int heightBlock, Level world) {
        if (world.m_5776_()) {
            throw new InvalidParameterException("Create canvas called on client");
        }
        String canvasCode = CanvasItem.createNewCanvasData(resolution, widthBlock, heightBlock, world);
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
        CanvasData canvasData = (CanvasData)((Object)canvasTracker.getCanvasData(canvasCode));
        assert (canvasData != null);
        CanvasItem.storeCanvasData(stack, canvasCode, canvasData);
        return canvasData;
    }

    public static void storeCanvasData(ItemStack stack, String canvasCode, CanvasData canvasData) {
        CanvasItem.setCanvasCode(stack, canvasCode);
        int widthBlocks = canvasData.getWidth() / canvasData.getResolution().getNumeric();
        int heightBlocks = canvasData.getHeight() / canvasData.getResolution().getNumeric();
        CanvasItem.setBlockSize(stack, widthBlocks, heightBlocks);
        stack.m_41784_().m_128405_(NBT_TAG_CACHED_RESOLUTION, canvasData.getResolution().getNumeric());
    }

    public static boolean isCompound(ItemStack stack) {
        int[] size = CanvasItem.getBlockSize(stack);
        if (size != null && size.length != 0) {
            return size[0] != 1 || size[1] != 1;
        }
        return false;
    }

    public static boolean isEmpty(ItemStack stack) {
        String canvasCode = CanvasItem.getCanvasCode(stack);
        return canvasCode == null;
    }

    @Nullable
    public static CanvasData getCanvasData(ItemStack stack, Level world) {
        Item canvas = stack.m_41720_();
        if (canvas instanceof CanvasItem) {
            String canvasCode = CanvasItem.getCanvasCode(stack);
            CanvasTracker canvasTracker = Helper.getLevelCanvasTracker(world);
            return (CanvasData)((Object)canvasTracker.getCanvasData(canvasCode));
        }
        return null;
    }

    @Nullable
    public static String getCanvasCode(ItemStack stack) {
        if (!stack.m_150930_((Item)ZetterItems.CANVAS.get())) {
            return null;
        }
        CompoundTag compoundNBT = stack.m_41783_();
        String canvasCode = null;
        if (compoundNBT != null && compoundNBT.m_128441_(NBT_TAG_CANVAS_CODE)) {
            canvasCode = compoundNBT.m_128461_(NBT_TAG_CANVAS_CODE);
        }
        return canvasCode;
    }

    public static void setCanvasCode(ItemStack stack, String canvasCode) {
        stack.m_41784_().m_128359_(NBT_TAG_CANVAS_CODE, canvasCode);
    }

    @Nullable
    public static Integer getCanvasId(@Nullable ItemStack stack) {
        String canvasCode = CanvasItem.getCanvasCode(stack);
        if (canvasCode == null) {
            return null;
        }
        return Integer.parseInt(canvasCode.substring("zetter_canvas_".length()));
    }

    public static void setBlockSize(ItemStack stack, int widthBlocks, int heightBlocks) {
        int[] size = new int[]{widthBlocks, heightBlocks};
        stack.m_41784_().m_128385_(NBT_TAG_CACHED_BLOCK_SIZE, size);
    }

    @Nullable
    public static int[] getBlockSize(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null || !compoundNBT.m_128441_(NBT_TAG_CACHED_BLOCK_SIZE)) {
            return new int[]{1, 1};
        }
        return compoundNBT.m_128465_(NBT_TAG_CACHED_BLOCK_SIZE);
    }

    public static String getStringSize(ItemStack stack) {
        int[] size = CanvasItem.getBlockSize(stack);
        if (size == null || size.length != 2) {
            return Component.m_237110_((String)"item.zetter.painting.size", (Object[])new Object[]{"1", "1"}).getString();
        }
        return Component.m_237110_((String)"item.zetter.painting.size", (Object[])new Object[]{Integer.toString(size[0]), Integer.toString(size[1])}).getString();
    }

    public static int getResolution(ItemStack stack) {
        CompoundTag compoundNBT = stack.m_41783_();
        if (compoundNBT == null) {
            return Helper.getResolution().getNumeric();
        }
        if (!compoundNBT.m_128441_(NBT_TAG_CACHED_RESOLUTION)) {
            compoundNBT.m_128405_(NBT_TAG_CACHED_RESOLUTION, Helper.getResolution().getNumeric());
        }
        return compoundNBT.m_128451_(NBT_TAG_CACHED_RESOLUTION);
    }

    private static String createNewCanvasData(AbstractCanvasData.Resolution resolution, int widthBlock, int heightBlock, Level level) {
        if (level.m_5776_()) {
            throw new InvalidParameterException("Create canvas called on client");
        }
        CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker(level);
        CanvasData canvasData = CanvasData.BUILDER.createFresh(resolution, widthBlock * resolution.getNumeric(), heightBlock * resolution.getNumeric());
        String canvasCode = CanvasData.getCanvasCode(canvasTracker.getFreeCanvasId());
        canvasTracker.registerCanvasData(canvasCode, canvasData);
        return canvasCode;
    }
}

