/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import com.mojang.datafixers.util.Either;
import me.dantaeusb.zetter.client.gui.overlay.CanvasOverlay;
import me.dantaeusb.zetter.client.gui.overlay.PaintingInfoOverlay;
import me.dantaeusb.zetter.client.gui.tooltip.CanvasTooltipRenderer;
import me.dantaeusb.zetter.core.ClientHelper;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.core.ZetterOverlays;
import me.dantaeusb.zetter.event.CanvasOverlayViewEvent;
import me.dantaeusb.zetter.event.CanvasRegisterEvent;
import me.dantaeusb.zetter.event.CanvasViewEvent;
import me.dantaeusb.zetter.item.FrameItem;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import me.dantaeusb.zetter.menu.EaselMenu;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="zetter", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ZetterClientModEvents {
    @SubscribeEvent
    public static void onCanvasViewed(CanvasViewEvent event) {
        AbstractCanvasData abstractCanvasData = event.canvasData;
        if (abstractCanvasData instanceof CanvasData) {
            CanvasData canvasCanvasData = (CanvasData)abstractCanvasData;
            ClientHelper.openCanvasScreen(event.player, event.canvasCode, canvasCanvasData, event.hand);
            event.setCanceled(true);
        } else {
            abstractCanvasData = event.canvasData;
            if (abstractCanvasData instanceof PaintingData) {
                PaintingData paintingData = (PaintingData)abstractCanvasData;
                ClientHelper.openPaintingScreen(event.player, event.canvasCode, paintingData, event.hand);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCanvasPreRegistered(CanvasRegisterEvent.Pre event) {
        if (!event.level.m_5776_()) {
            return;
        }
        String canvasCode = event.canvasCode;
        AbstractCanvasData canvasData = event.canvasData;
        long timestamp = event.timestamp;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (canvasData instanceof CanvasData) {
            EaselMenu easelMenu;
            String canvasItemCode;
            CanvasData canvasCanvasData = (CanvasData)canvasData;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof EaselMenu && (canvasItemCode = (easelMenu = (EaselMenu)abstractContainerMenu).getCanvasItemCode()) != null && canvasItemCode.equals(canvasCode) && easelMenu.handleCanvasSync(canvasCode, canvasCanvasData, timestamp)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onCanvasPostRegistered(CanvasRegisterEvent.Post event) {
        if (!event.level.m_5776_()) {
            return;
        }
        String canvasCode = event.canvasCode;
        AbstractCanvasData canvasData = event.canvasData;
        long timestamp = event.timestamp;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (canvasData instanceof CanvasData) {
            ArtistTableMenu artistTableMenu;
            CanvasData canvasCanvasData = (CanvasData)canvasData;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof ArtistTableMenu && (artistTableMenu = (ArtistTableMenu)abstractContainerMenu).handleCanvasSync(canvasCode, canvasCanvasData, timestamp)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void overlayViewEvent(CanvasOverlayViewEvent<?> event) {
        CanvasOverlay<?> overlay;
        if (event.canvasData instanceof PaintingData && ZetterOverlays.OVERLAYS.containsKey(PaintingData.OVERLAY_KEY) && (overlay = ZetterOverlays.OVERLAYS.get(PaintingData.OVERLAY_KEY)) instanceof PaintingInfoOverlay) {
            ((PaintingInfoOverlay)overlay).setCanvasData((PaintingData)((Object)event.canvasData));
        }
    }

    @SubscribeEvent
    public static void registerGatherTooltipComponent(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().m_150930_((Item)ZetterItems.PAINTING.get())) {
            event.getTooltipElements().add(0, Either.right((Object)new CanvasTooltipRenderer.CanvasComponent(event.getItemStack())));
        }
        if (event.getItemStack().m_150930_((Item)ZetterItems.CANVAS.get())) {
            event.getTooltipElements().add(0, Either.right((Object)new CanvasTooltipRenderer.CanvasComponent(event.getItemStack())));
        }
        for (RegistryObject<FrameItem> frame : ZetterItems.FRAMES.values()) {
            if (event.getItemStack().m_41720_() != frame.get() || FrameItem.getPaintingCode(event.getItemStack()) == null) continue;
            event.getTooltipElements().add(0, Either.right((Object)new CanvasTooltipRenderer.CanvasComponent(event.getItemStack())));
        }
    }
}

