/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterItems;
import me.dantaeusb.zetter.item.CanvasItem;
import me.dantaeusb.zetter.item.PaintingItem;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Timer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CanvasTooltipRenderer
implements ClientTooltipComponent {
    private static final ResourceLocation CANVAS_PENDING_BORDER_TEXTURE_RESOURCE = new ResourceLocation("zetter", "textures/gui/tooltip/canvas_pending_border.png");
    private static final ResourceLocation CANVAS_PENDING_LOADER_TEXTURE_RESOURCE = new ResourceLocation("zetter", "textures/gui/tooltip/canvas_pending_loader.png");
    private final CanvasComponent component;
    private final Timer loaderTimer = new Timer(3.0f, 0L);
    private int loaderFrame = 0;

    public CanvasTooltipRenderer(CanvasComponent component) {
        this.component = component;
    }

    public void tick() {
    }

    public void m_183452_(Font font, int tooltipX, int tooltipY, GuiGraphics guiGraphics) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = this.component.stack();
        String canvasCode = CanvasTooltipRenderer.getCanvasCode(stack);
        if (mc.f_91073_ == null || CanvasTooltipRenderer.getCanvasCode(stack) == null) {
            return;
        }
        CanvasTracker canvasTracker = Helper.getLevelCanvasTracker((Level)mc.f_91073_);
        Object canvasData = canvasTracker.getCanvasData(canvasCode);
        if (canvasData == null) {
            CanvasRenderer.getInstance().queueCanvasTextureUpdate(canvasCode);
            this.renderLoader(font, tooltipX, tooltipY, guiGraphics);
            return;
        }
        this.renderCanvas(font, tooltipX, tooltipY, guiGraphics, canvasCode, (AbstractCanvasData)((Object)canvasData));
    }

    private void renderCanvas(Font font, int tooltipX, int tooltipY, GuiGraphics guiGraphics, String canvasCode, AbstractCanvasData canvasData) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack pose = guiGraphics.m_280168_();
        float scale = CanvasTooltipRenderer.getScale(canvasData.getWidth(), canvasData.getHeight());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        pose.m_252880_((float)tooltipX, (float)tooltipY, 500.0f);
        pose.m_85841_(scale, scale, 1.0f);
        RenderSystem.enableBlend();
        pose.m_252880_(0.0f, 0.0f, 1.0f);
        CanvasRenderer.getInstance().renderCanvas(pose, (MultiBufferSource)guiGraphics.m_280091_(), canvasCode, canvasData, 0xF000F0);
        pose.m_85849_();
    }

    private void renderLoader(Font font, int tooltipX, int tooltipY, GuiGraphics guiGraphics) {
        PoseStack pose = guiGraphics.m_280168_();
        int[] size = CanvasTooltipRenderer.getCanvasSize(this.component.stack);
        int width = size[0];
        int height = size[1];
        float scale = CanvasTooltipRenderer.getScale(width, height);
        int scaledWidth = (int)((float)width * scale);
        int scaledHeight = (int)((float)height * scale);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        pose.m_85836_();
        pose.m_252880_((float)tooltipX, (float)tooltipY, 500.0f);
        pose.m_85841_(1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 0, 0, 3, 3, 0.0f, 0.0f, 3, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 3, 0, scaledWidth - 6, 3, 3.0f, 0.0f, 1, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, scaledWidth - 3, 0, 3, 3, 4.0f, 0.0f, 3, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, scaledWidth - 3, 3, 3, scaledHeight - 6, 4.0f, 3.0f, 3, 1, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, scaledWidth - 3, scaledHeight - 3, 3, 3, 4.0f, 4.0f, 3, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 3, scaledHeight - 3, scaledWidth - 6, 3, 3.0f, 4.0f, 1, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 0, scaledHeight - 3, 3, 3, 0.0f, 4.0f, 3, 3, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 0, 3, 3, scaledHeight - 6, 0.0f, 3.0f, 3, 1, 7, 7);
        guiGraphics.m_280411_(CANVAS_PENDING_BORDER_TEXTURE_RESOURCE, 3, 3, scaledWidth - 6, scaledHeight - 6, 3.0f, 3.0f, 1, 1, 7, 7);
        this.loaderFrame += this.loaderTimer.m_92525_(Util.m_137550_()) % 4;
        if (this.loaderFrame >= 4) {
            this.loaderFrame = 0;
        }
        if (this.loaderFrame == 3) {
            guiGraphics.m_280163_(CANVAS_PENDING_LOADER_TEXTURE_RESOURCE, scaledWidth / 2 - 8, scaledHeight / 2 - 5, 0.0f, 10.0f, 16, 10, 16, 30);
        } else {
            guiGraphics.m_280163_(CANVAS_PENDING_LOADER_TEXTURE_RESOURCE, scaledWidth / 2 - 8, scaledHeight / 2 - 5, 0.0f, (float)(10 * this.loaderFrame), 16, 10, 16, 30);
        }
        pose.m_85849_();
    }

    public int m_142103_() {
        if (CanvasTooltipRenderer.getCanvasCode(this.component.stack) == null) {
            return 0;
        }
        int[] size = CanvasTooltipRenderer.getCanvasSize(this.component.stack);
        int width = size[0];
        int height = size[1];
        return (int)(CanvasTooltipRenderer.getScale(width, height) * (float)height) + 4;
    }

    public int m_142069_(Font font) {
        if (CanvasTooltipRenderer.getCanvasCode(this.component.stack) == null) {
            return 0;
        }
        int[] size = CanvasTooltipRenderer.getCanvasSize(this.component.stack);
        int width = size[0];
        int height = size[1];
        return (int)(CanvasTooltipRenderer.getScale(width, height) * (float)width);
    }

    private static String getCanvasCode(ItemStack stack) {
        String canvasCode = stack.m_150930_((Item)ZetterItems.CANVAS.get()) ? CanvasItem.getCanvasCode(stack) : PaintingItem.getPaintingCode(stack);
        if (canvasCode == null || canvasCode.isEmpty()) {
            return null;
        }
        return canvasCode;
    }

    private static int[] getCanvasSize(ItemStack itemStack) {
        int[] size = CanvasItem.getBlockSize(itemStack);
        if (size == null) {
            return new int[]{Helper.getResolution().getNumeric(), Helper.getResolution().getNumeric()};
        }
        int width = size[0] * CanvasItem.getResolution(itemStack);
        int height = size[1] * CanvasItem.getResolution(itemStack);
        return new int[]{width, height};
    }

    private static float getScale(int width, int height) {
        return Math.min(1.0f / ((float)CanvasTooltipRenderer.getNearestPowerOfTwo(width) / 64.0f), 1.0f / ((float)CanvasTooltipRenderer.getNearestPowerOfTwo(height) / 64.0f));
    }

    private static int getNearestPowerOfTwo(int value) {
        int v = value;
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        return ++v;
    }

    public record CanvasComponent(ItemStack stack) implements TooltipComponent
    {
    }
}

