/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.easel;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.client.gui.EaselScreen;
import me.dantaeusb.zetter.client.gui.easel.AbstractEaselWidget;
import me.dantaeusb.zetter.core.tools.Color;
import me.dantaeusb.zetter.menu.EaselMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ColorCodeWidget
extends AbstractEaselWidget
implements Renderable {
    private static final int INACTIVE_COLOR = -9608371;
    static final int TEXTBOX_WIDTH = 82;
    static final int TEXTBOX_HEIGHT = 16;
    static final int TEXTBOX_TITLE_HEIGHT = 11;
    static final int TEXTBOX_TEXT_OFFSET = 10;
    private static final Pattern HEX_COLOR_PATTERN = Pattern.compile("\\p{XDigit}{1,6}");
    private static final Pattern HEX_COLOR_STRICT_PATTERN = Pattern.compile("(\\p{XDigit}{3}|\\p{XDigit}{6})");
    EditBox textField;
    Predicate<String> hexColorValidator = text -> {
        if (StringUtil.m_14408_((String)text)) {
            return true;
        }
        Matcher matcher = HEX_COLOR_PATTERN.matcher((CharSequence)text);
        return matcher.matches();
    };

    public ColorCodeWidget(EaselScreen parentScreen, int x, int y) {
        super(parentScreen, x, y, 82, 27, (Component)Component.m_237115_((String)"container.zetter.painting.color_code"));
    }

    @Override
    @Nullable
    public Component getTooltip(int mouseX, int mouseY) {
        return null;
    }

    public void initFields() {
        this.textField = new EditBox(this.parentScreen.getFont(), this.m_252754_() + 10 + 4, this.m_252907_() + 11 + 4, 75, 12, (Component)Component.m_237115_((String)"container.zetter.easel")){

            public void m_94164_(String text) {
                text = text.replaceAll("[^\\p{XDigit}]", "");
                super.m_94164_(text);
            }
        };
        this.textField.m_94202_(-9608371);
        this.textField.m_94205_(-9608371);
        this.textField.m_94182_(false);
        this.textField.m_94199_(6);
        this.textField.m_94151_(this::applyColor);
        this.textField.m_94153_(this.hexColorValidator);
    }

    public void tick() {
        this.textField.m_94120_();
    }

    public void updateColorValue(int color) {
        color &= 0xFFFFFF;
        if (this.textField.m_93696_()) {
            return;
        }
        this.textField.m_94144_(String.format("%1$06X", color));
    }

    private void applyColor(String text) {
        if (!this.textField.m_93696_()) {
            return;
        }
        Matcher matcher = HEX_COLOR_STRICT_PATTERN.matcher(text);
        if (!matcher.matches()) {
            return;
        }
        try {
            if (text.length() == 3) {
                StringBuilder longText = new StringBuilder();
                for (int i = 0; i < 3; ++i) {
                    longText.append(text.charAt(i));
                    longText.append(text.charAt(i));
                }
                text = longText.toString();
            }
            int color = Integer.parseInt(text, 16) | 0xFF000000;
            ((EaselMenu)this.parentScreen.m_6262_()).setPaletteColor(color);
        }
        catch (NumberFormatException exception) {
            Zetter.LOG.error("Invalid color number");
            return;
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.textField.m_93696_()) {
            if (Screen.m_96630_((int)keyCode)) {
                this.textField.m_94144_("");
            }
            return this.textField.m_7933_(keyCode, scanCode, modifiers) || this.textField.m_94204_();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (EaselScreen.isInRect(this.m_252754_(), this.m_252907_() + 11, 82, 16, (int)mouseX, (int)mouseY)) {
            this.m_93692_(true);
            this.textField.m_93692_(true);
            this.textField.m_94202_(Color.WHITE.getRGB());
            return true;
        }
        this.m_93692_(false);
        this.textField.m_93692_(false);
        this.textField.m_94202_(-9608371);
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.textField.m_5534_(codePoint, modifiers);
    }

    public void m_87963_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.drawTextbox(guiGraphics);
        this.textField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.parentScreen.getFont(), this.m_6035_(), this.m_252754_() - this.parentScreen.getGuiLeft(), this.m_252907_() - this.parentScreen.getGuiTop(), Color.darkGray.getRGB(), false);
    }

    protected void drawTextbox(GuiGraphics guiGraphics) {
        boolean TEXTBOX_POSITION_U = false;
        boolean TEXTBOX_POSITION_V = false;
        int textboxV = 0 + (this.textField.m_93696_() ? 16 : 0);
        guiGraphics.m_280218_(AbstractEaselWidget.EASEL_WIDGETS_TEXTURE_RESOURCE, this.m_252754_(), this.m_252907_() + 11, 0, textboxV, 82, 16);
    }
}

