/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.paintingregistry;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.paintingregistry.PaintingRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class PaintingRegistryStorage {
    private static final String NBT_TAG_PAINTING_LIST = "PaintingCanvasCodeList";
    private static final String SEPARATOR = new String(new byte[]{0}, StandardCharsets.UTF_8);
    private static final byte BYTE_SEPARATOR = SEPARATOR.getBytes(StandardCharsets.UTF_8)[0];

    public static Tag save(PaintingRegistry paintingRegistry) {
        CompoundTag compound = new CompoundTag();
        StringBuilder canvasCodeListBuilder = new StringBuilder();
        for (String canvasCode : paintingRegistry.getPaintingCanvasCodes()) {
            canvasCodeListBuilder.append(canvasCode);
            canvasCodeListBuilder.append(SEPARATOR);
        }
        compound.m_128382_(NBT_TAG_PAINTING_LIST, canvasCodeListBuilder.toString().getBytes(StandardCharsets.UTF_8));
        return compound;
    }

    public static void load(PaintingRegistry paintingRegistry, Tag tag) {
        if (tag.m_6458_() == CompoundTag.f_128326_) {
            CompoundTag compoundTag = (CompoundTag)tag;
            if (!compoundTag.m_128441_(NBT_TAG_PAINTING_LIST)) {
                return;
            }
            ByteBuffer canvasCodesBuffer = ByteBuffer.wrap(compoundTag.m_128463_(NBT_TAG_PAINTING_LIST));
            int lastZeroBytePosition = 0;
            while (canvasCodesBuffer.hasRemaining()) {
                if (canvasCodesBuffer.get() != BYTE_SEPARATOR) continue;
                ByteBuffer canvasCodeBuffer = canvasCodesBuffer.slice(lastZeroBytePosition, canvasCodesBuffer.position() - lastZeroBytePosition - 1);
                String canvasCode = StandardCharsets.UTF_8.decode(canvasCodeBuffer).toString();
                if (canvasCode.isEmpty() || canvasCode.contains(SEPARATOR)) {
                    Zetter.LOG.warn("Cannot deserialize canvas code from painting registry");
                } else {
                    paintingRegistry.addPaintingCanvasCode(canvasCode);
                }
                lastZeroBytePosition = canvasCodesBuffer.position();
            }
        }
    }
}

