/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.paintingregistry;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.paintingregistry.PaintingRegistry;
import me.dantaeusb.zetter.capability.paintingregistry.PaintingRegistryStorage;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PaintingRegistryProvider
implements ICapabilitySerializable<CompoundTag> {
    private final PaintingRegistry paintingRegistry;
    private final String TAG_NAME_PAINTING_REGISTRY = "PaintingRegistry";

    public PaintingRegistryProvider(Level world) {
        if (world.m_5776_()) {
            throw new IllegalArgumentException("Painting Registry should exist only on server in overworld");
        }
        this.paintingRegistry = new PaintingRegistry(world);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ZetterCapabilities.PAINTING_REGISTRY == capability) {
            return LazyOptional.of(() -> this.paintingRegistry);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.paintingRegistry.getWorld() == null || this.paintingRegistry.getWorld().m_5776_()) {
            return compoundTag;
        }
        Tag paintingRegistryTag = PaintingRegistryStorage.save(this.paintingRegistry);
        compoundTag.m_128365_("PaintingRegistry", paintingRegistryTag);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        if (this.paintingRegistry.getWorld() == null || this.paintingRegistry.getWorld().m_5776_()) {
            return;
        }
        Tag paintingRegistryTag = compoundTag.m_128423_("PaintingRegistry");
        if (paintingRegistryTag == null) {
            return;
        }
        PaintingRegistryStorage.load(this.paintingRegistry, paintingRegistryTag);
    }
}

