/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.canvastracker;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.core.ZetterRegistries;
import me.dantaeusb.zetter.event.CanvasRegisterEvent;
import me.dantaeusb.zetter.event.CanvasUnregisterEvent;
import me.dantaeusb.zetter.network.packet.SCanvasRemovalPacket;
import me.dantaeusb.zetter.network.packet.SCanvasSyncPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.PacketDistributor;

public class CanvasServerTracker
implements CanvasTracker {
    private ServerLevel level;
    protected BitSet canvasIds = new BitSet(1);
    protected int lastPaintingId = 0;
    private final Map<String, Vector<PlayerTrackingCanvas>> trackedCanvases = new HashMap<String, Vector<PlayerTrackingCanvas>>();
    private final Vector<String> desyncCanvases = new Vector();
    private int ticksFromLastSync = 0;

    @Override
    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("Cannot change level for capability");
        }
        if (!(level instanceof ServerLevel)) {
            throw new IllegalStateException("Only accepts ServerLevel");
        }
        this.level = (ServerLevel)level;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public BitSet getCanvasIds() {
        return this.canvasIds;
    }

    @Override
    public void setCanvasIds(BitSet canvasIds) {
        this.canvasIds = canvasIds;
    }

    public int getFreeCanvasId() {
        int freeId = this.canvasIds.nextClearBit(1);
        this.canvasIds.set(freeId);
        return freeId;
    }

    @Override
    public int getLastCanvasId() {
        return this.canvasIds.length() - 1;
    }

    private void clearCanvasId(int id) {
        this.canvasIds.clear(id);
    }

    public int getFreePaintingId() {
        return ++this.lastPaintingId;
    }

    @Override
    public int getLastPaintingId() {
        return this.lastPaintingId;
    }

    @Override
    public void setLastPaintingId(int id) {
        this.lastPaintingId = id;
    }

    public void markCanvasDesync(String canvasCode) {
        if (this.desyncCanvases.contains(canvasCode)) {
            return;
        }
        this.desyncCanvases.add(canvasCode);
    }

    @Override
    @Nullable
    public <T extends AbstractCanvasData> T getCanvasData(String canvasCode) {
        if (canvasCode == null) {
            return null;
        }
        return (T)((Object)((AbstractCanvasData)this.level.m_7654_().m_129783_().m_8895_().m_164858_(compoundTag -> {
            boolean deprecatedType;
            int canvasTypeInt = -1;
            Object canvasResourceLocation = compoundTag.m_128461_("CanvasDataType");
            if (((String)canvasResourceLocation).isEmpty()) {
                if (!compoundTag.m_128441_("type")) {
                    throw new IllegalStateException("Cannot find canvas type");
                }
                canvasTypeInt = compoundTag.m_128451_("type");
                switch (canvasTypeInt) {
                    case 1: {
                        canvasResourceLocation = ((CanvasDataType)ZetterCanvasTypes.CANVAS.get()).resourceLocation.toString();
                        break;
                    }
                    default: {
                        canvasResourceLocation = ((CanvasDataType)ZetterCanvasTypes.PAINTING.get()).resourceLocation.toString();
                    }
                }
            }
            boolean bl = deprecatedType = !((String)canvasResourceLocation).contains(":");
            if (deprecatedType) {
                canvasResourceLocation = "zetter:" + (String)canvasResourceLocation;
            }
            String finalCanvasResourceLocation = canvasResourceLocation;
            Optional<CanvasDataType> type = ZetterRegistries.CANVAS_TYPE.get().getEntries().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().toString().equals(finalCanvasResourceLocation)).map(Map.Entry::getValue).findFirst();
            if (type.isEmpty()) {
                throw new IllegalStateException("No type of canvas " + (String)canvasResourceLocation + " is registered");
            }
            Object canvasData = type.get().loadFromNbt((CompoundTag)compoundTag);
            ((AbstractCanvasData)((Object)((Object)canvasData))).correctData(this.level);
            if (canvasTypeInt != -1 || deprecatedType) {
                canvasData.m_77762_();
            }
            return canvasData;
        }, canvasCode)));
    }

    @Override
    public void registerCanvasData(String canvasCode, AbstractCanvasData canvasData, long timestamp) {
        if (!canvasData.isManaged()) {
            Zetter.LOG.error("Trying to register unmanaged canvas on server side");
            return;
        }
        CanvasRegisterEvent.Pre preEvent = new CanvasRegisterEvent.Pre(canvasCode, canvasData, (Level)this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        this.level.m_7654_().m_129783_().m_8895_().m_164855_(canvasCode, (SavedData)canvasData);
        CanvasRegisterEvent.Post postEvent = new CanvasRegisterEvent.Post(canvasCode, canvasData, (Level)this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    @Override
    public void unregisterCanvasData(String canvasCode) {
        Object canvasData = this.getCanvasData(canvasCode);
        if (canvasData == null) {
            Zetter.LOG.error("Cannot unregister non-existent canvas");
            return;
        }
        if (!((AbstractCanvasData)((Object)canvasData)).getType().equals(ZetterCanvasTypes.CANVAS.get())) {
            Zetter.LOG.error("Trying to unregister canvas of type " + ((AbstractCanvasData)((Object)canvasData)).getType().resourceLocation.toString() + " on server side, not supported yet");
            return;
        }
        long timestamp = System.currentTimeMillis();
        CanvasUnregisterEvent.Pre preEvent = new CanvasUnregisterEvent.Pre(canvasCode, (AbstractCanvasData)((Object)canvasData), (Level)this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        int canvasId = Integer.parseInt(canvasCode.substring("zetter_canvas_".length()));
        this.clearCanvasId(canvasId);
        Vector<PlayerTrackingCanvas> trackingPlayers = this.trackedCanvases.get(canvasCode);
        if (trackingPlayers != null) {
            for (PlayerTrackingCanvas trackingPlayer : trackingPlayers) {
                SCanvasRemovalPacket canvasRemovalPacket = new SCanvasRemovalPacket(canvasCode, System.currentTimeMillis());
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.level.m_46003_(trackingPlayer.playerId)), (Object)canvasRemovalPacket);
            }
        }
        CanvasUnregisterEvent.Post postEvent = new CanvasUnregisterEvent.Post(canvasCode, (AbstractCanvasData)((Object)canvasData), (Level)this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    public void tick() {
        ++this.ticksFromLastSync;
        if (this.ticksFromLastSync < 20) {
            return;
        }
        MinecraftServer server = this.level.m_7654_();
        for (String canvasCode : this.desyncCanvases) {
            for (PlayerTrackingCanvas playerTrackingCanvas : this.getTrackingEntries(canvasCode)) {
                ServerPlayer playerEntity = server.m_6846_().m_11259_(playerTrackingCanvas.playerId);
                SCanvasSyncPacket canvasSyncMessage = new SCanvasSyncPacket(canvasCode, this.getCanvasData(canvasCode), System.currentTimeMillis());
                ZetterNetwork.simpleChannel.send(PacketDistributor.PLAYER.with(() -> playerEntity), canvasSyncMessage);
            }
        }
        this.desyncCanvases.clear();
        this.ticksFromLastSync = 0;
    }

    public void trackCanvas(UUID playerId, String canvasName) {
        Vector<PlayerTrackingCanvas> trackingEntries = this.getTrackingEntries(canvasName);
        for (PlayerTrackingCanvas playerTrackingCanvas : trackingEntries) {
            if (playerTrackingCanvas.playerId != playerId) continue;
            return;
        }
        trackingEntries.add(new PlayerTrackingCanvas(playerId, canvasName));
    }

    public void stopTrackingCanvas(UUID playerId, String canvasName) {
        if (!this.trackedCanvases.containsKey(canvasName)) {
            return;
        }
        Vector<PlayerTrackingCanvas> trackingEntries = this.trackedCanvases.get(canvasName);
        trackingEntries.removeIf(entry -> entry.playerId == playerId);
    }

    public void stopTrackingAllCanvases(UUID playerId) {
        for (String canvasName : this.trackedCanvases.keySet()) {
            this.stopTrackingCanvas(playerId, canvasName);
        }
    }

    private Vector<PlayerTrackingCanvas> getTrackingEntries(String canvasName) {
        return this.trackedCanvases.computeIfAbsent(canvasName, k -> new Vector());
    }

    private static class PlayerTrackingCanvas {
        public final UUID playerId;
        public final String canvasName;

        PlayerTrackingCanvas(UUID playerId, String canvasName) {
            this.playerId = playerId;
            this.canvasName = canvasName;
        }
    }
}

