/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ZetterConfig {
    static final ForgeConfigSpec serverSpec;
    public static final Server SERVER;
    static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair serverPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)serverPair.getRight();
        SERVER = (Server)serverPair.getLeft();
        Pair clientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.ConfigValue<String> resolution;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Painting options");
            builder.push("painting");
            ArrayList<String> availableResolution = new ArrayList<String>(Arrays.asList("x16", "x32", "x64"));
            this.resolution = builder.comment("The size of paintings on that server [x16, x32, 64]").translation("forge.configgui.zetter.painting.resolution").defineInList("resolution", (Object)((String)availableResolution.get(0)), availableResolution);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.ConfigValue<Boolean> enableHelpButton;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("GUI options");
            builder.push("gui");
            this.enableHelpButton = builder.comment("Show small help button in the top right corner of the screen that leads to online manual").translation("forge.configgui.zetter.gui.helpButton").define("help_button", true);
            builder.pop();
        }
    }
}

