/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.data.v2;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRecipeProvider
extends RecipeProvider {
    private final String modId;

    public AbstractRecipeProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractRecipeProvider(String modId, PackOutput packOutput) {
        super(packOutput);
        this.modId = modId;
    }

    @Nullable
    private static <T> JsonElement searchAndReplaceValue(@Nullable JsonElement jsonElement, T searchFor, T replaceWith) {
        block10: {
            block11: {
                Objects.requireNonNull(searchFor, "search for is null");
                Objects.requireNonNull(replaceWith, "replace with is null");
                if (jsonElement == null || jsonElement.isJsonNull()) break block10;
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = jsonElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isNumber()) {
                        if (searchFor.equals(jsonPrimitive.getAsNumber())) {
                            return new JsonPrimitive((Number)replaceWith);
                        }
                    } else if (jsonPrimitive.isBoolean()) {
                        if (searchFor.equals(jsonPrimitive.getAsBoolean())) {
                            return new JsonPrimitive((Boolean)replaceWith);
                        }
                    } else if (jsonPrimitive.isString() && searchFor.toString().equals(jsonPrimitive.getAsString())) {
                        return new JsonPrimitive(replaceWith.toString());
                    }
                    return jsonElement;
                }
                if (!jsonElement.isJsonArray()) break block11;
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    jsonArray.set(i, AbstractRecipeProvider.searchAndReplaceValue(jsonArray.get(i), searchFor, replaceWith));
                }
                break block10;
            }
            if (!jsonElement.isJsonObject()) break block10;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (Map.Entry entry : jsonObject.entrySet()) {
                entry.setValue(AbstractRecipeProvider.searchAndReplaceValue((JsonElement)entry.getValue(), searchFor, replaceWith));
            }
        }
        return jsonElement;
    }

    protected static String getHasName(ItemLike item, ItemLike ... items) {
        return "has_" + Stream.concat(Stream.of(item), Stream.of(items)).map(x$0 -> RecipeProvider.m_176632_((ItemLike)x$0)).collect(Collectors.joining("_and_"));
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike item, ItemLike ... items) {
        return AbstractRecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])Stream.concat(Stream.of(item), Stream.of(items)).toArray(ItemLike[]::new)).m_45077_()});
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashSet set = Sets.newHashSet();
        ArrayList list = new ArrayList();
        this.m_245200_(finishedRecipe -> {
            ResourceLocation id = new ResourceLocation(this.modId, finishedRecipe.m_6445_().m_135815_());
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate recipe " + id);
            }
            list.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)finishedRecipe.m_125966_(), (Path)this.f_236355_.m_245731_(id)));
            JsonObject jsonElement = finishedRecipe.m_5860_();
            if (jsonElement != null) {
                jsonElement = AbstractRecipeProvider.searchAndReplaceValue((JsonElement)jsonElement, finishedRecipe.m_6445_(), id);
                ResourceLocation advancementId = new ResourceLocation(this.modId, finishedRecipe.m_6448_().m_135815_());
                list.add(DataProvider.m_253162_((CachedOutput)output, (JsonElement)jsonElement, (Path)this.f_236356_.m_245731_(advancementId)));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public final void m_245200_(Consumer<FinishedRecipe> exporter) {
        this.addRecipes(exporter);
    }

    public abstract void addRecipes(Consumer<FinishedRecipe> var1);
}

