/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.data.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzlesaccessapi.api.client.data.v2.BlockModelBuilder;
import fuzs.puzzlesaccessapi.api.client.data.v2.ItemModelBuilder;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class AbstractModelProvider
implements DataProvider {
    public static final String BLOCK_PATH = "block";
    public static final String ITEM_PATH = "item";
    private final String modId;
    private final PackOutput.PathProvider blockStatePathProvider;
    private final PackOutput.PathProvider modelPathProvider;

    public AbstractModelProvider(DataProviderContext context) {
        this(context.getModId(), context.getPackOutput());
    }

    public AbstractModelProvider(String modId, PackOutput packOutput) {
        this.modId = modId;
        this.blockStatePathProvider = packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.modelPathProvider = packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
    }

    public abstract void addBlockModels(BlockModelBuilder var1);

    public abstract void addItemModels(ItemModelBuilder var1);

    protected boolean throwForMissingBlocks() {
        return true;
    }

    public CompletableFuture<?> m_213708_(CachedOutput output) {
        HashMap generators = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = generator -> {
            Block block = generator.m_6968_();
            BlockStateGenerator blockstategenerator = generators.put(block, generator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate block state definition for " + block);
            }
        };
        HashMap models = Maps.newHashMap();
        HashSet skippedAutoModels = Sets.newHashSet();
        BiConsumer<ResourceLocation, Supplier> modelOutput = (resourceLocation, supplier) -> {
            if (models.put(resourceLocation, supplier) != null) {
                throw new IllegalStateException("Duplicate model definition for " + resourceLocation);
            }
        };
        this.addBlockModels(new BlockModelBuilder(blockStateOutput, modelOutput, skippedAutoModels::add));
        this.addItemModels(new ItemModelBuilder(modelOutput));
        List<Object> missingBlocks = this.throwForMissingBlocks() ? BuiltInRegistries.f_256975_.m_6579_().stream().filter(entry -> ((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) && !generators.containsKey(entry.getValue())).map(Map.Entry::getValue).toList() : Collections.emptyList();
        if (!missingBlocks.isEmpty()) {
            throw new IllegalStateException("Missing block state definitions for " + missingBlocks);
        }
        BuiltInRegistries.f_256975_.m_6579_().forEach(entry -> {
            Item item = (Item)Item.f_41373_.get(entry.getValue());
            if (item != null) {
                if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals(this.modId) || skippedAutoModels.contains(item)) {
                    return;
                }
                ResourceLocation resourcelocation = ModelLocationUtils.m_125571_((Item)item);
                if (!models.containsKey(resourcelocation)) {
                    models.put(resourcelocation, new DelegatedModel(ModelLocationUtils.m_125576_((Block)((Block)entry.getValue()))));
                }
            }
        });
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = AbstractModelProvider.saveCollection(output, generators, block -> this.blockStatePathProvider.m_245731_(block.m_204297_().m_205785_().m_135782_()));
        completableFutureArray[1] = AbstractModelProvider.saveCollection(output, models, arg_0 -> ((PackOutput.PathProvider)this.modelPathProvider).m_245731_(arg_0));
        return CompletableFuture.allOf(completableFutureArray);
    }

    public final String m_6055_() {
        return "Model Definitions";
    }

    private static <T> CompletableFuture<?> saveCollection(CachedOutput output, Map<T, ? extends Supplier<JsonElement>> map, Function<T, Path> pathExtractor) {
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            Path path = (Path)pathExtractor.apply(entry.getKey());
            JsonElement jsonElement = (JsonElement)((Supplier)entry.getValue()).get();
            return DataProvider.m_253162_((CachedOutput)output, (JsonElement)jsonElement, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public static ResourceLocation getModelLocation(Block block) {
        return AbstractModelProvider.decorateBlockModelLocation(AbstractModelProvider.getLocation(block));
    }

    public static ResourceLocation decorateBlockModelLocation(ResourceLocation resourceLocation) {
        return resourceLocation.m_246208_("block/");
    }

    public static ResourceLocation getLocation(Block block) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)block);
    }

    public static String getName(Block block) {
        return AbstractModelProvider.getLocation(block).m_135815_();
    }

    public static ResourceLocation getModelLocation(Item item) {
        return AbstractModelProvider.decorateItemModelLocation(AbstractModelProvider.getLocation(item));
    }

    public static ResourceLocation decorateItemModelLocation(ResourceLocation resourceLocation) {
        return resourceLocation.m_246208_("item/");
    }

    public static ResourceLocation getLocation(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item);
    }

    public static String getName(Item item) {
        return AbstractModelProvider.getLocation(item).m_135815_();
    }

    public static ResourceLocation stripUntil(ResourceLocation resourceLocation, String s) {
        String path = resourceLocation.m_135815_();
        if (path.contains(s)) {
            path = path.substring(path.lastIndexOf(s) + 1);
            return new ResourceLocation(resourceLocation.m_135827_(), path);
        }
        return resourceLocation;
    }

    public static ModelTemplate.JsonFactory overrides(ModelTemplate modelTemplate, ItemOverride.Factory ... factories) {
        return (resourceLocation, map) -> {
            JsonObject jsonObject = modelTemplate.m_266532_(resourceLocation, map);
            JsonArray jsonArray = new JsonArray();
            for (ItemOverride.Factory factory : factories) {
                jsonArray.add(((ItemOverride)factory.apply(resourceLocation)).toJson());
            }
            jsonObject.add("overrides", (JsonElement)jsonArray);
            return jsonObject;
        };
    }

    public record ItemOverride(ResourceLocation model, Map<ResourceLocation, Float> predicates) {
        public static ItemOverride of(ResourceLocation model, ResourceLocation p1, float f1) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1)));
        }

        public static ItemOverride of(ResourceLocation model, ResourceLocation p1, float f1, ResourceLocation p2, float f2) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1), p2, Float.valueOf(f2)));
        }

        public static ItemOverride of(ResourceLocation model, ResourceLocation p1, float f1, ResourceLocation p2, float f2, ResourceLocation p3, float f3) {
            return new ItemOverride(model, Map.of(p1, Float.valueOf(f1), p2, Float.valueOf(f2), p3, Float.valueOf(f3)));
        }

        JsonElement toJson() {
            JsonObject jsonObject = new JsonObject();
            JsonObject predicates = new JsonObject();
            for (Map.Entry<ResourceLocation, Float> entry : this.predicates.entrySet()) {
                predicates.addProperty(entry.getKey().toString(), (Number)entry.getValue());
            }
            jsonObject.add("predicate", (JsonElement)predicates);
            jsonObject.addProperty("model", this.model.toString());
            return jsonObject;
        }

        public static interface Factory
        extends Function<ResourceLocation, ItemOverride> {
        }
    }
}

