/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropwateringcans.item.wateringCan;

import cool.bot.botslib.util.RNG;
import cool.bot.botslib.util.Util;
import cool.bot.dewdropwateringcans.Config;
import cool.bot.dewdropwateringcans.event.WateringCanFailEvent;
import cool.bot.dewdropwateringcans.event.WateringCanFillEvent;
import cool.bot.dewdropwateringcans.event.WateringCanPourEvent;
import cool.bot.dewdropwateringcans.event.WateringCanSuperEvent;
import cool.bot.dewdropwateringcans.item.ModItems;
import cool.bot.dewdropwateringcans.item.wateringCan.WateringCanItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WateringCanEventsHandler {
    @SubscribeEvent
    public static void onWateringCanPourEvent(WateringCanPourEvent event) {
        ServerLevel level = event.serverLevel;
        ServerPlayer player = event.player;
        ItemStack stack = event.stack;
        BlockPos pos = event.pos;
        BlockState state = event.state;
        boolean isSuper = event.isSuper;
        if (!isSuper) {
            stack.m_220157_(1, RandomSource.m_216327_(), null);
            WateringCanEventsHandler.resetCooldown(player, stack);
        }
        if (!(!level.m_46472_().equals((Object)ServerLevel.f_46429_) || Config.allowNether || Config.allowNetheriteCanAnyways && stack.m_150930_((Item)ModItems.NETHERITE_WATERING_CAN.get()))) {
            for (int i = 0; i < 8; ++i) {
                double offsetX = 0.5;
                double offsetY = state.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
                double offsetZ = 0.5;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + offsetZ, 0, 0.0, 0.0, 0.0, 1.0);
            }
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 3.0f);
            return;
        }
        if (isSuper && state.m_60795_()) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
        }
        if (Util.isDryWaterable((ServerLevel)level, (BlockPos)pos)) {
            Util.setMoist((ServerLevel)level, (BlockPos)pos);
        } else if (state.m_204336_(BlockTags.f_13073_) && Util.isDryWaterable((ServerLevel)level, (BlockPos)pos.m_7495_())) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
            Util.setMoist((ServerLevel)level, (BlockPos)pos);
        } else if (Config.mudOdds > 0 && (state.m_60713_(Blocks.f_50493_) || state.m_60713_(Blocks.f_50546_) || state.m_60713_(Blocks.f_152549_)) && RNG.ihundo((int)Config.mudOdds)) {
            level.m_7731_(pos, Blocks.f_220864_.m_49966_(), 3);
            level.m_5594_(null, pos, SoundEvents.f_215711_, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (Config.extinguishFires) {
            if (state.m_204336_(BlockTags.f_13087_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            } else if (state.m_204336_(BlockTags.f_13076_)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        level.m_5594_(null, pos, SoundEvents.f_11968_, SoundSource.PLAYERS, 1.0f, 3.0f);
        for (int i = 0; i < 15; ++i) {
            double offsetX = RandomSource.m_216327_().m_188500_() - 0.5;
            double offsetY = state.m_60808_((BlockGetter)level, pos).m_83297_(Direction.Axis.Y);
            double offsetZ = RandomSource.m_216327_().m_188500_() - 0.5;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123761_, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (Config.bonemealOdds > 0 && RNG.ihundo((int)Config.bonemealOdds)) {
            pos = pos.m_7494_();
            state = level.m_8055_(pos);
            Block block = state.m_60734_();
            if (state.m_204336_(BlockTags.f_13073_) && block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                crop.m_214148_(level, level.m_213780_(), pos, state);
            }
        }
    }

    @SubscribeEvent
    public static void onWateringCanFailEvent(WateringCanFailEvent event) {
        ServerLevel serverLevel = event.serverLevel;
        ServerPlayer player = event.player;
        ItemStack stack = event.stack;
        player.m_6330_(SoundEvents.f_12026_, SoundSource.PLAYERS, 1.0f, 1.0f);
        WateringCanEventsHandler.resetCooldown(player, stack);
    }

    @SubscribeEvent
    public static void onWateringCanFillEvent(WateringCanFillEvent event) {
        ServerLevel serverLevel = event.serverLevel;
        ServerPlayer player = event.player;
        ItemStack stack = event.stack;
        stack.m_41721_(0);
        serverLevel.m_5594_(null, player.m_20097_(), SoundEvents.f_11964_, SoundSource.PLAYERS, 1.0f, 1.0f);
        WateringCanEventsHandler.resetCooldown(player, stack);
    }

    @SubscribeEvent
    public static void onWateringCanSuperEvent(WateringCanSuperEvent event) {
        ServerLevel level = event.serverLevel;
        ServerPlayer player = event.player;
        ItemStack stack = event.stack;
        int superLevel = event.superLevel;
        AABB area = event.area;
        int areaSize = (int)BlockPos.m_121921_((AABB)area).count();
        if (areaSize > stack.m_41776_() - stack.m_41773_() && !player.m_7500_()) {
            MinecraftForge.EVENT_BUS.post((Event)new WateringCanFailEvent(level, player, stack));
            return;
        }
        BlockPos.m_121921_((AABB)area).forEach(blockPos -> {
            BlockState state = level.m_8055_(blockPos);
            MinecraftForge.EVENT_BUS.post((Event)new WateringCanPourEvent(level, player, stack, (BlockPos)blockPos, state, true));
        });
        if (!player.m_7500_()) {
            stack.m_220157_(areaSize, RandomSource.m_216327_(), null);
        }
        WateringCanEventsHandler.resetCooldown(player, stack);
    }

    private static void resetCooldown(ServerPlayer player, ItemStack stack) {
        player.m_36335_().m_41524_(stack.m_41720_(), ((WateringCanItem)stack.m_41720_()).getCooldown());
    }
}

