/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiStackProvider;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.mixin.accessor.CraftingResultSlotAccessor;
import dev.emi.emi.mixin.accessor.HandledScreenAccessor;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class EmiStackProviders {
    public static Map<Class<?>, List<EmiStackProvider<?>>> fromClass = Maps.newHashMap();
    public static List<EmiStackProvider<?>> generic = Lists.newArrayList();

    public static void clear() {
        fromClass.clear();
        generic.clear();
    }

    public static EmiStackInteraction getStackAt(Screen screen, int x, int y, boolean notClick) {
        HandledScreenAccessor handled;
        Slot s;
        EmiStackInteraction stack;
        if (fromClass.containsKey(screen.getClass())) {
            for (EmiStackProvider<?> provider : fromClass.get(screen.getClass())) {
                stack = provider.getStackAt(screen, x, y);
                if (stack.isEmpty() || !notClick && !stack.isClickable()) continue;
                return stack;
            }
        }
        for (EmiStackProvider<?> handler : generic) {
            stack = handler.getStackAt(screen, x, y);
            if (stack.isEmpty() || !notClick && !stack.isClickable()) continue;
            return stack;
        }
        if (notClick && screen instanceof HandledScreenAccessor && (s = (handled = (HandledScreenAccessor)screen).getFocusedSlot()) != null && !(stack = s.m_7993_()).m_41619_()) {
            if (s instanceof ResultSlot) {
                ResultSlot craf = (ResultSlot)s;
                try {
                    CraftingContainer inv = ((CraftingResultSlotAccessor)craf).getInput();
                    Minecraft client = Minecraft.m_91087_();
                    List list = client.f_91073_.m_7465_().m_44056_(RecipeType.f_44107_, (Container)inv, (Level)client.f_91073_);
                    if (!list.isEmpty()) {
                        ResourceLocation id = EmiPort.getId((Recipe)list.get(0));
                        EmiRecipe recipe = EmiApi.getRecipeManager().getRecipe(id);
                        if (recipe != null) {
                            return new EmiStackInteraction(EmiStack.of((ItemStack)stack), recipe, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new EmiStackInteraction(EmiStack.of((ItemStack)stack));
        }
        return EmiStackInteraction.EMPTY;
    }
}

