/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EmiRepairItemRecipe
extends EmiPatternCraftingRecipe {
    public static final List<Item> TOOLS = EmiPort.getItemRegistry().m_123024_().filter(Item::m_41465_).collect(Collectors.toList());
    private final Item tool;

    public EmiRepairItemRecipe(Item tool, ResourceLocation id) {
        super(List.of(EmiStack.of((ItemLike)tool), EmiStack.of((ItemLike)tool)), EmiStack.of((ItemLike)tool), id);
        this.tool = tool;
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            List<ItemStack> items = this.getItems((Random)r);
            if (slot < 2) {
                return EmiStack.of(items.get(slot));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> EmiStack.of(this.getMergeItems((Random)r)), this.unique, x, y);
    }

    private List<ItemStack> getItems(Random random) {
        ArrayList items = Lists.newArrayList();
        items.add(this.getTool(random));
        items.add(this.getTool(random));
        return items;
    }

    private ItemStack getMergeItems(Random random) {
        List<ItemStack> items = this.getItems(random);
        ItemStack item = this.tool.m_7968_();
        int maxDamage = this.tool.m_41462_();
        int damage = items.get(0).m_41773_() - 21 * maxDamage / 20 + items.get(1).m_41773_();
        if (damage > 0) {
            item.m_41721_(damage);
        }
        return item;
    }

    private ItemStack getTool(Random r) {
        ItemStack stack = this.tool.m_7968_();
        if (stack.m_41776_() <= 0) {
            return stack;
        }
        int d = r.nextInt(stack.m_41776_());
        stack.m_41721_(d);
        return stack;
    }
}

