/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.config;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.config.ConfigEnum;
import dev.emi.emi.platform.EmiAgnos;
import it.unimi.dsi.fastutil.doubles.Double2ObjectFunction;
import net.minecraft.network.chat.Component;

public enum FluidUnit implements ConfigEnum
{
    LITERS("liters", (Double2ObjectFunction<Component>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.liters", EmiRenderHelper.TEXT_FORMAT.format((int)(a / (double)FluidUnit.literDivisor()))))),
    MILLIBUCKETS("millibuckets", (Double2ObjectFunction<Component>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.millibuckets", EmiRenderHelper.TEXT_FORMAT.format((int)(a / (double)FluidUnit.literDivisor()))))),
    DROPLETS("droplets", (Double2ObjectFunction<Component>)((Double2ObjectFunction)a -> EmiPort.translatable("emi.fluid.amount.droplets", EmiRenderHelper.TEXT_FORMAT.format((int)a))));

    public static final int BUCKET;
    public static final int BOTTLE;
    private final String name;
    private final Component translation;
    private final Double2ObjectFunction<Component> translator;

    private FluidUnit(String name, Double2ObjectFunction<Component> translator) {
        this.name = name;
        this.translation = EmiPort.translatable("emi.unit." + name);
        this.translator = translator;
    }

    public static int literDivisor() {
        if (EmiAgnos.isForge()) {
            return 1;
        }
        return 81;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Component translate(double amount) {
        return (Component)this.translator.apply((Object)amount);
    }

    @Override
    public Component getText() {
        return this.translation;
    }

    static {
        BUCKET = EmiAgnos.isForge() ? 1000 : 81000;
        BOTTLE = EmiAgnos.isForge() ? 250 : 27000;
    }
}

