/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.chess;

import com.google.common.collect.Lists;
import dev.emi.emi.chess.ChessBoard;
import dev.emi.emi.chess.ChessEvaluation;
import dev.emi.emi.chess.ChessMove;
import dev.emi.emi.chess.ChessPiece;
import dev.emi.emi.chess.MoveGenerator;
import dev.emi.emi.chess.PieceColor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class StandardMoveGenerator
extends MoveGenerator {
    public ChessEvaluation eval = new ChessEvaluation();
    public ChessMove chosenMove;
    public Thread worker;

    public StandardMoveGenerator(PieceColor color) {
        super(color);
    }

    @Override
    public void ponderMove(ChessBoard board) {
        this.chosenMove = null;
        this.worker = new Thread(new Worker(board));
        this.worker.start();
    }

    @Override
    public boolean determinedMove() {
        return this.worker != null && !this.worker.isAlive();
    }

    @Override
    public ChessMove getMove() {
        return this.chosenMove;
    }

    public int evaluate(ChessBoard board, PieceColor turn, int depth, int alpha, int beta) {
        List<ChessMove> moves = board.getAllMoves(turn);
        for (int i = 0; i < moves.size(); ++i) {
            int value;
            ChessMove move = moves.get(i);
            int rCastles = board.castles;
            ChessMove rLast = board.lastMove;
            ChessPiece captured = board.get(move.end());
            board.move(move);
            if (depth <= 0) {
                value = this.eval.evaluate(board);
                if (turn == PieceColor.BLACK) {
                    value = -value;
                }
            } else {
                value = -this.evaluate(board, turn.opposite(), depth - 1, -beta, -alpha);
            }
            board.unmove(move);
            board.castles = rCastles;
            board.lastMove = rLast;
            board.set(move.end(), captured);
            if (value >= beta) {
                return value;
            }
            if (value <= alpha) continue;
            alpha = value;
        }
        return alpha;
    }

    class Worker
    implements Runnable {
        private ChessBoard board;

        public Worker(ChessBoard board) {
            this.board = board;
        }

        @Override
        public void run() {
            int bestEval = -2147483647;
            ChessMove bestMove = null;
            ArrayList legal = Lists.newArrayList(this.board.getLegal(this.board.getAllMoves(StandardMoveGenerator.this.color)).iterator());
            Collections.shuffle(legal);
            for (ChessMove move : legal) {
                ChessBoard copy = this.board.copy();
                copy.move(move);
                int eval = -StandardMoveGenerator.this.evaluate(copy, StandardMoveGenerator.this.color.opposite(), 4, -2147483647, Integer.MAX_VALUE);
                if (eval <= bestEval) continue;
                bestEval = eval;
                bestMove = move;
            }
            StandardMoveGenerator.this.chosenMove = bestMove;
        }
    }
}

