/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.forge.terraform.boat.impl.entity;

import de.cristelknight.doapi.forge.terraform.boat.api.TerraformBoatTypeRegistry;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public interface TerraformBoatHolder {
    public static final String BOAT_KEY = "TerraformBoat";

    public TerraformBoatType getTerraformBoat();

    public void setTerraformBoat(TerraformBoatType var1);

    default public boolean hasValidTerraformBoat() {
        return this.getTerraformBoat() != null;
    }

    default public void readTerraformBoatFromNbt(CompoundTag nbt) {
        TerraformBoatType boat;
        ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_128461_(BOAT_KEY));
        if (id != null && (boat = TerraformBoatTypeRegistry.get(id)) != null) {
            this.setTerraformBoat(boat);
        }
    }

    default public void writeTerraformBoatToNbt(CompoundTag nbt) {
        ResourceLocation boatId = TerraformBoatTypeRegistry.getId(this.getTerraformBoat());
        if (boatId != null) {
            nbt.m_128359_(BOAT_KEY, boatId.toString());
        }
    }

    default public Boat.Type getImpersonatedBoatType() {
        return this.getTerraformBoat().isRaft() ? Boat.Type.BAMBOO : Boat.Type.OAK;
    }
}

