/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.registry;

import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.redstone.displayLink.source.FactoryGaugeDisplaySource;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.createmod.catnip.data.IntAttached;
import net.liukrast.eg.api.EGRegistries;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.ApiStatus;

public class EGPanelConnections {
    static final Map<PanelConnection<?>, Function<FactoryPanelBehaviour, ?>> FACTORY_CONNECTIONS = new Reference2ObjectArrayMap();
    private static final DeferredRegister<PanelConnection<?>> CONNECTIONS = DeferredRegister.create(EGRegistries.PANEL_CONNECTION_REGISTRY_KEY, (String)"extra_gauges");
    public static final RegistryObject<PanelConnection<FilterItemStack>> FILTER = CONNECTIONS.register("filter", PanelConnection::new);
    public static final RegistryObject<PanelConnection<Integer>> REDSTONE = CONNECTIONS.register("redstone", PanelConnection::new);
    public static final RegistryObject<PanelConnection<Integer>> INTEGER = CONNECTIONS.register("integer", PanelConnection::new);
    public static final RegistryObject<PanelConnection<String>> STRING = CONNECTIONS.register("string", PanelConnection::new);

    private EGPanelConnections() {
    }

    public static <T> Optional<T> getConnectionValue(FactoryPanelBehaviour behaviour, RegistryObject<PanelConnection<T>> panelConnection) {
        return EGPanelConnections.getConnectionValue(behaviour, (PanelConnection)panelConnection.get());
    }

    public static <T> Optional<T> getConnectionValue(FactoryPanelBehaviour behaviour, PanelConnection<T> panelConnection) {
        if (behaviour == null) {
            return Optional.empty();
        }
        if (behaviour instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour abstractPanelBehaviour = (AbstractPanelBehaviour)behaviour;
            return abstractPanelBehaviour.getConnectionValue(panelConnection);
        }
        if (!FACTORY_CONNECTIONS.containsKey(panelConnection)) {
            return Optional.empty();
        }
        return Optional.of(FACTORY_CONNECTIONS.get(panelConnection).apply(behaviour));
    }

    @ApiStatus.Internal
    public static void register(IEventBus eventBus) {
        CONNECTIONS.register(eventBus);
    }

    public static void initDefaults() {
        FACTORY_CONNECTIONS.clear();
        FACTORY_CONNECTIONS.put((PanelConnection)FILTER.get(), FilteringBehaviour::getFilter);
        FACTORY_CONNECTIONS.put((PanelConnection)REDSTONE.get(), b -> b.satisfied && b.count != 0 ? 15 : 0);
        FACTORY_CONNECTIONS.put((PanelConnection)INTEGER.get(), FactoryPanelBehaviour::getLevelInStorage);
        FACTORY_CONNECTIONS.put((PanelConnection)STRING.get(), b -> {
            IntAttached source = ((FactoryGaugeDisplaySource)AllDisplaySources.GAUGE_STATUS.get()).createEntry(b.getWorld(), b.getPanelPosition());
            return source == null ? null : String.valueOf(source.getFirst()) + ((MutableComponent)source.getValue()).getString();
        });
    }

    public static Collection<PanelConnection<?>> getConnections(FactoryPanelBehaviour at) {
        if (at instanceof AbstractPanelBehaviour) {
            AbstractPanelBehaviour ab = (AbstractPanelBehaviour)at;
            return ab.getConnections();
        }
        return FACTORY_CONNECTIONS.keySet();
    }
}

