/*
 * Decompiled with CFR 0.152.
 */
package net.liukrast.eg.content.logistics.board;

import com.mojang.serialization.Codec;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.liukrast.eg.ExtraGaugesConfig;
import net.liukrast.eg.api.logistics.board.AbstractPanelBehaviour;
import net.liukrast.eg.api.logistics.board.PanelConnection;
import net.liukrast.eg.api.registry.PanelType;
import net.liukrast.eg.api.util.CacheContainer;
import net.liukrast.eg.api.util.ConnectionExtra;
import net.liukrast.eg.content.logistics.IntSelectorBlockEntity;
import net.liukrast.eg.content.logistics.board.IntOperationMode;
import net.liukrast.eg.content.logistics.board.ScrollOptionPanelBehaviour;
import net.liukrast.eg.registry.EGItems;
import net.liukrast.eg.registry.EGPanelConnections;
import net.liukrast.eg.registry.EGPartialModels;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class IntPanelBehaviour
extends ScrollOptionPanelBehaviour<IntOperationMode>
implements CacheContainer<Integer> {
    private int updated = 0;
    private final Map<BlockPos, Integer> cache = new HashMap<BlockPos, Integer>();

    public IntPanelBehaviour(PanelType<?> type, FactoryPanelBlockEntity be, FactoryPanelBlock.PanelSlot slot) {
        super((Component)Component.m_237115_((String)"create.logistics.int_operation"), type, be, slot, IntOperationMode.class);
    }

    @Override
    public void addConnections(AbstractPanelBehaviour.PanelConnectionBuilder builder) {
        builder.put(EGPanelConnections.INTEGER, () -> this.count);
        builder.put(EGPanelConnections.REDSTONE, () -> Mth.m_14045_((int)this.count, (int)0, (int)15));
        builder.put((PanelConnection)EGPanelConnections.STRING.get(), () -> this.getDisplayLinkComponent(false).getString());
    }

    @Override
    public Item getItem() {
        return (Item)EGItems.INT_GAUGE.get();
    }

    @Override
    public PartialModel getModel(FactoryPanelBlock.PanelState panelState, FactoryPanelBlock.PanelType panelType) {
        return EGPartialModels.INT_PANEL;
    }

    @Override
    public Map<BlockPos, Integer> cacheMap() {
        return this.cache;
    }

    @Override
    public Codec<Integer> cacheCodec() {
        return Codec.INT;
    }

    @Override
    public void easyWrite(CompoundTag nbt, boolean clientPacket) {
        super.easyWrite(nbt, clientPacket);
        nbt.m_128405_("Count", this.count);
    }

    @Override
    public void easyRead(CompoundTag nbt, boolean clientPacket) {
        super.easyRead(nbt, clientPacket);
        this.count = nbt.m_128451_("Count");
    }

    public void tick() {
        super.tick();
        this.updated = 0;
    }

    public void checkForRedstoneInput() {
        if (!this.active || this.updated > (Integer)ExtraGaugesConfig.INT_MAX_CHAIN.get()) {
            return;
        }
        ArrayList countList = new ArrayList();
        this.consumeForLinks(link -> {
            SmartBlockEntity patt3163$temp;
            if (link.shouldPanelBePowered() && (patt3163$temp = link.blockEntity) instanceof RedstoneLinkBlockEntity) {
                RedstoneLinkBlockEntity redstoneLink = (RedstoneLinkBlockEntity)patt3163$temp;
                countList.add(redstoneLink.getReceivedSignal());
            } else {
                SmartBlockEntity patt3318$temp = link.blockEntity;
                if (patt3318$temp instanceof IntSelectorBlockEntity) {
                    IntSelectorBlockEntity intSelector = (IntSelectorBlockEntity)patt3318$temp;
                    countList.add(intSelector.behaviour.getValue());
                } else {
                    countList.add(link.shouldPanelBePowered() ? 1 : 0);
                }
            }
        });
        this.consumeForExtra((PanelConnection)EGPanelConnections.INTEGER.get(), (pos, v) -> {
            countList.add(v);
            this.cache.put((BlockPos)pos, (Integer)v);
        });
        this.consumeForPanels((PanelConnection)EGPanelConnections.INTEGER.get(), countList::add);
        this.sendCache(this);
        int result = ((IntOperationMode)((Object)this.get())).test(countList.stream());
        if (result == this.count) {
            return;
        }
        this.count = result;
        this.blockEntity.notifyUpdate();
        ++this.updated;
        this.notifyRedstoneOutputs();
    }

    @Override
    public int calculatePath(FactoryPanelBehaviour other, int original) {
        if (EGPanelConnections.getConnectionValue(other, EGPanelConnections.INTEGER).isPresent()) {
            return 25750;
        }
        return super.calculatePath(other, original);
    }

    @Override
    public int calculateExtraPath(BlockPos pos) {
        ConnectionExtra listener;
        Level level = this.getWorld();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        ConnectionExtra intListener = ((PanelConnection)EGPanelConnections.INTEGER.get()).getListener(state.m_60734_());
        if (intListener != null) {
            Optional opt = intListener.invalidate(level, state, pos, be);
            Integer cache = this.cache.get(pos);
            if (opt.isPresent()) {
                return (Boolean)ExtraGaugesConfig.PANEL_CACHING.get() == false || ((Integer)opt.get()).equals(cache) ? 25750 : 16766273;
            }
        }
        if ((listener = ((PanelConnection)EGPanelConnections.REDSTONE.get()).getListener(state.m_60734_())) == null) {
            return super.calculateExtraPath(pos);
        }
        return listener.invalidate(level, state, pos, be).map(v -> {
            boolean k = v == 0;
            Integer cache = this.cache.get(pos);
            if (((Boolean)ExtraGaugesConfig.PANEL_CACHING.get()).booleanValue() && cache != null && k == cache > 0) {
                return 16766273;
            }
            return k ? 5767425 : 0xEF0000;
        }).orElse(super.calculateExtraPath(pos));
    }

    @Override
    public MutableComponent getDisplayLinkComponent(boolean shortened) {
        int n = this.getConnectionValue(EGPanelConnections.INTEGER).orElse(0);
        String text = shortened ? IntPanelBehaviour.formatNumber(n) : String.valueOf(n);
        return Component.m_237113_((String)text);
    }

    private static String formatNumber(int number) {
        boolean negative = number < 0;
        if ((number = Math.abs(number)) >= 1000000) {
            return (negative ? "-" : "") + String.format("%.1fM", Float.valueOf((float)number / 1000000.0f));
        }
        if (number >= 1000) {
            return (negative ? "-" : "") + String.format("%.1fK", Float.valueOf((float)number / 1000.0f));
        }
        return (negative ? "-" : "") + number;
    }
}

