/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.networking.packets;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import me.duquee.createutilities.CreateUtilitiesClient;
import me.duquee.createutilities.blocks.voidtypes.motor.VoidMotorNetworkHandler;
import me.duquee.createutilities.blocks.voidtypes.tank.VoidTank;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class VoidTankUpdatePacket
extends SimplePacketBase {
    private final VoidMotorNetworkHandler.NetworkKey key;
    private final FluidTank tank;

    public VoidTankUpdatePacket(VoidMotorNetworkHandler.NetworkKey key, VoidTank tank) {
        this.key = key;
        this.tank = tank;
    }

    public VoidTankUpdatePacket(FriendlyByteBuf buffer) {
        this.key = VoidMotorNetworkHandler.NetworkKey.fromBuffer(buffer);
        this.tank = new FluidTank(VoidTank.CAPACITY).readFromNBT(buffer.m_130260_());
    }

    public void write(FriendlyByteBuf buffer) {
        this.key.writeToBuffer(buffer);
        buffer.m_130079_(this.tank.writeToNBT(new CompoundTag()));
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> CreateUtilitiesClient.VOID_TANKS.storages.put(this.key, this.tank)));
        return true;
    }
}

