/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes.battery;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import me.duquee.createutilities.CreateUtilities;
import me.duquee.createutilities.CreateUtilitiesClient;
import me.duquee.createutilities.blocks.voidtypes.VoidLinkBehaviour;
import me.duquee.createutilities.blocks.voidtypes.battery.VoidBattery;
import me.duquee.createutilities.blocks.voidtypes.battery.VoidBatteryBlock;
import me.duquee.createutilities.blocks.voidtypes.battery.VoidBatteryData;
import me.duquee.createutilities.voidlink.VoidLinkSlot;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VoidBatteryTileEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    VoidLinkBehaviour link;

    public VoidBatteryTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void createLink() {
        Triple<VoidLinkSlot, VoidLinkSlot, VoidLinkSlot> slots = VoidLinkSlot.makeSlots(index -> new VoidLinkSlot((int)index, state -> (Direction)state.m_61143_((Property)VoidBatteryBlock.f_54117_), VecHelper.voxelSpace((double)5.5, (double)10.5, (double)-0.001f)));
        this.link = new VoidLinkBehaviour(this, slots);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    private boolean hasPersistentData() {
        return this.f_58857_ != null && !this.f_58857_.f_46443_;
    }

    private static VoidBatteryData getPersistentStorageData() {
        return CreateUtilities.VOID_BATTERIES_DATA;
    }

    public VoidBattery getBattery() {
        return this.hasPersistentData() ? VoidBatteryTileEntity.getPersistentStorageData().computeStorageIfAbsent(this.link.getNetworkKey()) : CreateUtilitiesClient.VOID_BATTERIES.computeStorageIfAbsent(this.link.getNetworkKey());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return LazyOptional.of(this::getBattery).cast();
        }
        return super.getCapability(cap, side);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (clientPacket) {
            this.getBattery().deserializeNBT(tag.m_128469_("Battery"));
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        if (clientPacket) {
            tag.m_128365_("Battery", (Tag)this.getBattery().serializeNBT());
        }
        super.write(tag, clientPacket);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VoidBattery battery = this.getBattery();
        new LangBuilder("createutilities").translate("tooltip.void_battery.header", new Object[0]).forGoggles(tooltip);
        new LangBuilder("createutilities").translate("tooltip.void_battery.energy", new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
        new LangBuilder("createutilities").add(new LangBuilder("createutilities").text(battery.getEnergyStored() + "fe").style(ChatFormatting.GOLD)).add(new LangBuilder("createutilities").text(" / ").style(ChatFormatting.GRAY)).add(new LangBuilder("createutilities").text(battery.getMaxEnergyStored() + "fe").style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }
}

