/*
 * Decompiled with CFR 0.152.
 */
package me.duquee.createutilities.blocks.voidtypes;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import me.duquee.createutilities.voidlink.VoidLinkRenderer;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;

public interface VoidTileRenderer<T extends SmartBlockEntity> {
    public SkullModelBase getSkullModelBase();

    public boolean shouldRenderFrame(T var1, Direction var2);

    public float getFrameWidth();

    public float getFrameOffset(Direction var1);

    default public void renderVoid(T te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        VoidLinkRenderer.renderOnTileEntity(te, partialTicks, ms, buffer, light, overlay, this.getSkullModelBase());
        this.renderPortal(te, ms.m_85850_().m_252922_(), buffer.m_6299_(RenderType.m_173239_()));
    }

    private void renderPortal(T te, Matrix4f pose, VertexConsumer consumer) {
        float x = (1.0f - this.getFrameWidth()) * 0.5f;
        float z = (1.0f + this.getFrameWidth()) * 0.5f;
        block8: for (Direction direction : Direction.values()) {
            if (!this.shouldRenderFrame(te, direction)) continue;
            float offSetValue = this.getFrameOffset(direction);
            switch (direction) {
                case DOWN: {
                    this.renderFrame(pose, consumer, x, z, 1.0f - offSetValue, 1.0f - offSetValue, x, x, z, z);
                    continue block8;
                }
                case UP: {
                    this.renderFrame(pose, consumer, x, z, offSetValue, offSetValue, z, z, x, x);
                    continue block8;
                }
                case NORTH: {
                    this.renderFrame(pose, consumer, x, z, z, x, 1.0f - offSetValue, 1.0f - offSetValue, 1.0f - offSetValue, 1.0f - offSetValue);
                    continue block8;
                }
                case SOUTH: {
                    this.renderFrame(pose, consumer, x, z, x, z, offSetValue, offSetValue, offSetValue, offSetValue);
                    continue block8;
                }
                case WEST: {
                    this.renderFrame(pose, consumer, 1.0f - offSetValue, 1.0f - offSetValue, x, z, x, z, z, x);
                    continue block8;
                }
                case EAST: {
                    this.renderFrame(pose, consumer, offSetValue, offSetValue, z, x, x, z, z, x);
                }
            }
        }
    }

    private void renderFrame(Matrix4f pose, VertexConsumer consumer, float x0, float x1, float y0, float y1, float z0, float z1, float z2, float z3) {
        consumer.m_252986_(pose, x0, y0, z0).m_5752_();
        consumer.m_252986_(pose, x1, y0, z1).m_5752_();
        consumer.m_252986_(pose, x1, y1, z2).m_5752_();
        consumer.m_252986_(pose, x0, y1, z3).m_5752_();
    }
}

