/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class TInventoryTile
extends TileMultipart
implements WorldlyContainer {
    private List<Container> invList = new ArrayList<Container>();
    private int sizeSum = 0;
    private int[] invSize = new int[0];
    private int[][] faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);

    public TInventoryTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void copyFrom(TileMultipart that) {
        super.copyFrom(that);
        if (that instanceof TInventoryTile) {
            this.invList = ((TInventoryTile)that).invList;
            this.rebuildSlotMap();
        }
    }

    @Override
    public void bindPart(MultiPart part) {
        super.bindPart(part);
        if (part instanceof Container) {
            this.invList.add((Container)part);
            this.rebuildSlotMap();
        }
    }

    @Override
    public void partRemoved(MultiPart part, int p) {
        super.partRemoved(part, p);
        if (part instanceof Container) {
            this.invList.remove(part);
            this.rebuildSlotMap();
        }
    }

    @Override
    public void clearParts() {
        super.clearParts();
        this.invList.clear();
        this.sizeSum = 0;
        this.invSize = new int[0];
        this.faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);
    }

    private void rebuildSlotMap() {
        this.sizeSum = this.invList.stream().mapToInt(Container::m_6643_).sum();
        this.invSize = this.invList.stream().mapToInt(Container::m_6643_).toArray();
        this.faceSlots = (int[][])ArrayUtils.fill((Object[])new int[6][0], null);
    }

    public void m_6211_() {
        for (Container inv : this.invList) {
            inv.m_6211_();
        }
    }

    public int m_6643_() {
        return this.sizeSum;
    }

    public boolean m_7983_() {
        for (Container inv : this.invList) {
            if (inv.m_7983_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).m_7407_(slot, count);
    }

    public ItemStack m_8016_(int slot) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        return this.invList.get(i).m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        this.invList.get(i).m_6836_(slot, stack);
    }

    public int[] m_7071_(Direction side) {
        int[] slots = this.faceSlots[side.ordinal()];
        if (slots == null) {
            IntArrayList intList = new IntArrayList();
            int base = 0;
            for (Container inv : this.invList) {
                if (inv instanceof WorldlyContainer) {
                    WorldlyContainer s = (WorldlyContainer)inv;
                    int finalBase = base;
                    Arrays.stream(s.m_7071_(side)).map(j -> j + finalBase).forEach(arg_0 -> ((IntList)intList).add(arg_0));
                }
                base += inv.m_6643_();
            }
            slots = intList.toIntArray();
            this.faceSlots[side.ordinal()] = slots;
        }
        return slots;
    }

    public boolean m_7155_(int slot, ItemStack stack, @Nullable Direction side) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        Container inv = this.invList.get(i);
        if (inv instanceof WorldlyContainer) {
            WorldlyContainer s = (WorldlyContainer)inv;
            return s.m_7155_(slot, stack, side);
        }
        return true;
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        int i = 0;
        while (slot >= this.invSize[i]) {
            slot -= this.invSize[i];
            ++i;
        }
        Container inv = this.invList.get(i);
        if (inv instanceof WorldlyContainer) {
            WorldlyContainer s = (WorldlyContainer)inv;
            return s.m_7157_(slot, stack, side);
        }
        return true;
    }

    public boolean m_6542_(Player player) {
        return true;
    }
}

