/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.blay09.mods.trashslot.network.MessageTrashSlotContent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MessageDeleteFromSlot {
    private final int slotNumber;
    private final boolean isDeleteAll;

    public MessageDeleteFromSlot(int slotNumber, boolean isDeleteAll) {
        this.slotNumber = slotNumber;
        this.isDeleteAll = isDeleteAll;
    }

    public static void encode(MessageDeleteFromSlot message, FriendlyByteBuf buf) {
        buf.m_130130_(message.slotNumber);
        buf.writeBoolean(message.isDeleteAll);
    }

    public static MessageDeleteFromSlot decode(FriendlyByteBuf buf) {
        int slotNumber = buf.m_130242_();
        boolean isDeleteAll = buf.readBoolean();
        return new MessageDeleteFromSlot(slotNumber, isDeleteAll);
    }

    public static void handle(ServerPlayer player, MessageDeleteFromSlot message) {
        if (player.m_5833_()) {
            return;
        }
        if (message.slotNumber == -1) {
            TrashHelper.setTrashItem((Player)player, ItemStack.f_41583_);
            Balm.getNetworking().reply((Object)new MessageTrashSlotContent(ItemStack.f_41583_));
            return;
        }
        if (!player.f_36096_.m_142621_().m_41619_()) {
            return;
        }
        AbstractContainerMenu container = player.f_36096_;
        Slot deleteSlot = (Slot)container.f_38839_.get(message.slotNumber);
        if (deleteSlot instanceof ResultSlot) {
            return;
        }
        if (message.isDeleteAll) {
            ItemStack deleteStack = deleteSlot.m_7993_().m_41777_();
            if (!deleteStack.m_41619_() && MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, message.slotNumber)) {
                ItemStack slotStack;
                for (int i = 0; i < container.f_38839_.size() && ((slotStack = ((Slot)container.f_38839_.get(i)).m_7993_()).m_41619_() || !ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)deleteStack) || MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, i)); ++i) {
                }
            }
        } else {
            MessageDeleteFromSlot.attemptDeleteFromSlot((Player)player, container, message.slotNumber);
        }
        Balm.getNetworking().reply((Object)new MessageTrashSlotContent(TrashHelper.getTrashItem((Player)player)));
    }

    private static boolean attemptDeleteFromSlot(Player player, AbstractContainerMenu container, int slotNumber) {
        ItemStack itemStack = ((Slot)container.f_38839_.get(slotNumber)).m_7993_().m_41777_();
        ResourceLocation registryName = Balm.getRegistries().getKey(itemStack.m_41720_());
        if (registryName != null && TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
            return false;
        }
        container.m_150399_(slotNumber, 0, ClickType.PICKUP, player);
        ItemStack mouseStack = container.m_142621_();
        if (ItemStack.m_41728_((ItemStack)itemStack, (ItemStack)mouseStack)) {
            container.m_142503_(ItemStack.f_41583_);
            TrashHelper.setTrashItem(player, mouseStack);
            return !itemStack.m_41619_();
        }
        ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-1, 0, 0, mouseStack));
        return false;
    }
}

