/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.menu;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import tanukidecor.TanukiDecor;
import tanukidecor.client.ClientRecipeCollections;
import tanukidecor.client.menu.widget.DIYRecipeButton;
import tanukidecor.client.menu.widget.ScrollButton;
import tanukidecor.menu.DIYWorkbenchMenu;

public class DIYWorkbenchScreen
extends AbstractContainerScreen<DIYWorkbenchMenu>
implements ScrollButton.IScrollListener {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tanukidecor", "textures/gui/diy_workbench.png");
    public static final int WIDTH = 182;
    public static final int HEIGHT = 216;
    private static final int SEARCH_X = 57;
    private static final int SEARCH_Y = 35;
    private static final int SEARCH_WIDTH = 96;
    private static final int SEARCH_HEIGHT = 10;
    private static final int RECIPE_BUTTON_COUNT_Y = 4;
    private static final int RECIPE_X = 11;
    private static final int RECIPE_Y = 49;
    private static final int SCROLL_X = 159;
    private static final int SCROLL_Y = 49;
    private static final int SCROLL_HEIGHT = 72;
    private static final Comparator<RecipeCollection> SORT_RECIPES_BY_RESULT_NAME = Comparator.comparing(recipeCollection -> recipeCollection.m_100516_().isEmpty() ? "" : ((Recipe)recipeCollection.m_100516_().get(0)).m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41786_().getString());
    private final Collection<RecipeCollection> recipes = ImmutableList.sortedCopyOf(SORT_RECIPES_BY_RESULT_NAME, ClientRecipeCollections.DIY_RECIPE_COLLECTIONS);
    private final SearchTree<RecipeCollection> searchTree = Minecraft.m_91087_().m_231372_(ClientRecipeCollections.DIY_RECIPE_COLLECTIONS_KEY);
    private final List<RecipeCollection> sortedRecipes = new ArrayList<RecipeCollection>(this.recipes.size());
    private final List<DIYRecipeButton> recipeButtons = new ArrayList<DIYRecipeButton>(4);
    private ScrollButton scrollButton;
    private EditBox editBox;
    private int scrollOffset;
    private Component resultCountText;

    public DIYWorkbenchScreen(DIYWorkbenchMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 182;
        this.f_97727_ = 216;
        this.f_97730_ = 11;
        this.f_97731_ = 123;
        this.f_97729_ = 5;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.scrollButton = (ScrollButton)this.m_142416_((GuiEventListener)new ScrollButton(this.f_97735_ + 159, this.f_97736_ + 49, 12, 72, TEXTURE, 244, 0, 12, 15, 15, true, 1.0f, this));
        this.scrollOffset = 0;
        this.editBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_97735_ + 57, this.f_97736_ + 35, 96, 10, (Component)Component.m_237115_((String)"container.search")));
        this.editBox.m_94190_(false);
        this.editBox.m_94202_(-1);
        this.editBox.m_94205_(-1);
        this.editBox.m_94182_(false);
        this.editBox.m_94199_(70);
        this.editBox.m_94144_("");
        this.editBox.m_94151_(s -> this.updateRecipes((String)s));
        this.m_264313_((GuiEventListener)this.editBox);
        this.recipeButtons.clear();
        Button.OnPress recipeButtonOnPress = b -> ((DIYWorkbenchMenu)this.m_6262_()).selectRecipe(((DIYRecipeButton)b).getRecipe());
        ItemRenderer itemRenderer = this.getMinecraft().m_91291_();
        int x = this.f_97735_ + 11;
        int y = this.f_97736_ + 49;
        for (int i = 0; i < 4; ++i) {
            this.recipeButtons.add((DIYRecipeButton)this.m_142416_((GuiEventListener)new DIYRecipeButton(x, y + i * 18, itemRenderer, this.f_96547_, recipeButtonOnPress)));
        }
        this.updateRecipes("");
    }

    public void m_6574_(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.editBox.m_94155_();
        super.m_6574_(pMinecraft, pWidth, pHeight);
        this.editBox.m_94144_(s);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            ((DIYWorkbenchMenu)this.m_6262_()).getInventory().f_35978_.m_6915_();
        }
        return this.editBox.m_7933_(pKeyCode, pScanCode, pModifiers) || this.editBox.m_94204_() || super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_181908_() {
        super.m_181908_();
        this.editBox.m_94120_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.enableDepthTest();
        guiGraphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        FormattedCharSequence formattedCharSequence = this.resultCountText.m_7532_();
        Objects.requireNonNull(this.f_96547_);
        guiGraphics.m_280649_(this.f_96547_, formattedCharSequence, this.f_97735_ + 57 + 96 + 4, this.f_97736_ + 35 + (10 - 9) / 2, 0x404040, false);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    private void updateRecipes(String filter) {
        this.sortedRecipes.clear();
        if (!((Boolean)TanukiDecor.CONFIG.isDIYWorkbenchEnabled.get()).booleanValue()) {
            return;
        }
        if (filter.isEmpty()) {
            this.sortedRecipes.addAll(this.recipes);
        } else {
            this.sortedRecipes.addAll(this.searchTree.m_6293_(filter.toLowerCase(Locale.ROOT)));
        }
        this.scrollButton.setScrollAmountMultiplier(1.0f / (float)Math.max(1, this.sortedRecipes.size() - 4));
        this.scrollButton.f_93623_ = this.sortedRecipes.size() > 4;
        this.resultCountText = Component.m_237113_((String)("" + this.sortedRecipes.size()));
        this.updateRecipeButtons();
    }

    private void updateRecipeButtons() {
        int n = this.recipeButtons.size();
        for (int i = 0; i < n; ++i) {
            DIYRecipeButton button = this.recipeButtons.get(i);
            int index = i + this.scrollOffset;
            if (index < 0 || index >= this.sortedRecipes.size() || this.sortedRecipes.get(index).m_100516_().isEmpty()) {
                button.f_93623_ = false;
                button.f_93624_ = false;
                continue;
            }
            button.f_93623_ = true;
            button.f_93624_ = true;
            button.setRecipe((Recipe)this.sortedRecipes.get(index).m_100516_().get(0));
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.m_6774_(11, 49, 143, 72, pMouseX, pMouseY)) {
            return this.scrollButton.m_6050_(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrollButton != null && this.scrollButton.isDragging()) {
            this.scrollButton.m_7212_(mouseX, mouseY, dragX, dragY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public void onScroll(ScrollButton button, float percent) {
        int oldScrollOffset = this.scrollOffset;
        this.scrollOffset = Mth.m_14143_((float)Math.max(0.0f, percent * (float)Math.max(0, this.sortedRecipes.size() - 4)));
        if (oldScrollOffset != this.scrollOffset) {
            this.updateRecipeButtons();
        }
    }

    public static Tooltip createTooltip(List<Component> list) {
        MutableComponent component = Component.m_237119_();
        for (Component c : list) {
            component.m_7360_().add(c);
            component.m_7360_().add(Component.m_237113_((String)"\n"));
        }
        if (component.m_7360_().size() > 1) {
            component.m_7360_().remove(component.m_7360_().size() - 1);
        }
        return Tooltip.m_257550_((Component)component);
    }
}

