/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.client.blockentity.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import tanukidecor.block.clock.IChimeProvider;
import tanukidecor.block.entity.NewtonsCradleBlockEntity;
import tanukidecor.block.misc.NewtonsCradleBlock;

public class NewtonsCradleBER
implements BlockEntityRenderer<NewtonsCradleBlockEntity> {
    public static final ResourceLocation BALL = new ResourceLocation("tanukidecor", "block/newtons_cradle/ball");
    protected static final Vector3f LINE_START = new Vector3f(0.25f, 0.5f, 0.3125f);
    protected static final Vector3f LINE_MID = new Vector3f(0.25f, 0.25f, 0.5f);
    protected static final Vector3f LINE_END = new Vector3f(0.25f, 0.5f, 0.6875f);
    protected final BlockRenderDispatcher blockRenderer;

    public NewtonsCradleBER(BlockEntityRendererProvider.Context pContext) {
        this.blockRenderer = pContext.m_173584_();
    }

    public void render(NewtonsCradleBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        float startX;
        BlockState blockState = pBlockEntity.m_58900_();
        Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_);
        float time = (float)((int)(pBlockEntity.m_58904_().m_46467_() % 24000L)) + pPartialTick;
        IChimeProvider chimeProvider = (IChimeProvider)pBlockEntity.m_58900_().m_60734_();
        Minecraft mc = Minecraft.m_91087_();
        BakedModel ballModel = mc.m_91304_().getModel(BALL);
        float timeFactor = (float)Math.PI / (float)chimeProvider.getTickSoundInterval(blockState);
        float maxAngle = 0.6981317f;
        float bias = 1.5707964f * (float)Mth.m_14205_((double)pBlockEntity.getBias());
        float enabledMultiplier = (Boolean)blockState.m_61143_((Property)NewtonsCradleBlock.ENABLED) != false ? 1.0f : 0.0f;
        float angle = enabledMultiplier * 0.6981317f * Mth.m_14031_((float)(time * timeFactor + bias));
        float westBallAngle = Math.max(0.0f, angle);
        float eastBallAngle = -Math.min(0.0f, angle);
        RenderType renderType = RenderType.m_110451_();
        VertexConsumer modelVertexConsumer = pBufferSource.m_6299_(renderType);
        float dx = 0.5f;
        float dy = 0.5f;
        float dz = 0.5f;
        float zRotation = 0.0f;
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(dx, dy, dz);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(direction.m_122435_()));
        pPoseStack.m_252880_(-dx, -dy, -dz);
        dx = 0.5f;
        dy = 0.5f;
        dz = 0.46875f;
        zRotation = westBallAngle;
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(0.25f, 0.0f, 0.0f);
        pPoseStack.m_252880_(dx, dy, dz);
        pPoseStack.m_252781_(Axis.f_252403_.m_252961_(zRotation));
        pPoseStack.m_252880_(-dx, -dy, -dz);
        this.blockRenderer.m_110937_().renderModel(pPoseStack.m_85850_(), modelVertexConsumer, blockState, ballModel, 1.0f, 1.0f, 1.0f, pPackedLight, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        pPoseStack.m_85849_();
        zRotation = eastBallAngle;
        pPoseStack.m_85836_();
        pPoseStack.m_252880_(-0.25f, 0.0f, 0.0f);
        pPoseStack.m_252880_(dx, dy, dz);
        pPoseStack.m_252781_(Axis.f_252393_.m_252961_(zRotation));
        pPoseStack.m_252880_(-dx, -dy, -dz);
        this.blockRenderer.m_110937_().renderModel(pPoseStack.m_85850_(), modelVertexConsumer, blockState, ballModel, 1.0f, 1.0f, 1.0f, pPackedLight, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        pPoseStack.m_85849_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        VertexConsumer lineVertexConsumer = pBufferSource.m_6299_((RenderType)RenderType.f_110371_);
        for (int i = 0; i < 3; ++i) {
            startX = LINE_START.x() + (float)(i + 1) * 0.125f;
            NewtonsCradleBER.cradleLineStrip(pPoseStack, lineVertexConsumer, startX, LINE_START.y(), LINE_START.z(), startX, LINE_MID.y(), LINE_MID.z(), startX, LINE_END.y(), LINE_END.z());
        }
        float radius = 0.25f;
        startX = LINE_START.x() + 0.5f;
        float midX = startX + radius * Mth.m_14031_((float)westBallAngle);
        float midY = LINE_MID.y() + radius - radius * Mth.m_14089_((float)westBallAngle);
        NewtonsCradleBER.cradleLineStrip(pPoseStack, lineVertexConsumer, startX, LINE_START.y(), LINE_START.z(), midX, midY, LINE_MID.z(), startX, LINE_END.y(), LINE_END.z());
        startX = LINE_START.x();
        midX = startX - radius * Mth.m_14031_((float)eastBallAngle);
        midY = LINE_MID.y() + radius - radius * Mth.m_14089_((float)eastBallAngle);
        NewtonsCradleBER.cradleLineStrip(pPoseStack, lineVertexConsumer, startX, LINE_START.y(), LINE_START.z(), midX, midY, LINE_MID.z(), startX, LINE_END.y(), LINE_END.z());
        pPoseStack.m_85849_();
    }

    public static void addSpecialModels(Set<ResourceLocation> list) {
        list.add(BALL);
    }

    private static void cradleLineStrip(PoseStack poseStack, VertexConsumer vertexConsumer, float startX, float startY, float startZ, float midX, float midY, float midZ, float endX, float endY, float endZ) {
        PoseStack.Pose lastPose = poseStack.m_85850_();
        Matrix4f matrix4f = lastPose.m_252922_();
        vertexConsumer.m_252986_(matrix4f, startX, startY, startZ).m_6122_(10, 10, 10, 255).m_252939_(lastPose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, midX, midY, midZ).m_6122_(10, 10, 10, 255).m_252939_(lastPose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, midX, midY, midZ).m_6122_(10, 10, 10, 255).m_252939_(lastPose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix4f, endX, endY, endZ).m_6122_(10, 10, 10, 255).m_252939_(lastPose.m_252943_(), 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

