/*
 * Decompiled with CFR 0.152.
 */
package tanukidecor.block.misc;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import tanukidecor.block.RotatingTallBlock;

public class BirdcageBlock
extends RotatingTallBlock {
    public static final VoxelShape COLLISION_SHAPE_UPPER = Shapes.m_83124_((VoxelShape)BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)2.01), (VoxelShape[])new VoxelShape[]{BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)13.99, (double)14.0, (double)15.0, (double)14.0), BirdcageBlock.m_49796_((double)13.99, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)2.01, (double)15.0, (double)14.0), BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)0.01, (double)14.0), BirdcageBlock.m_49796_((double)2.0, (double)14.99, (double)2.0, (double)14.0, (double)15.0, (double)14.0)});
    public static final VoxelShape SHAPE_UPPER = Shapes.m_83110_((VoxelShape)BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)BirdcageBlock.m_49796_((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));
    public static final VoxelShape SHAPE_LOWER = Shapes.m_83110_((VoxelShape)BirdcageBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape)BirdcageBlock.m_49796_((double)6.5, (double)2.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5));
    private static final TagKey<EntityType<?>> BIRDCAGE_BLACKLIST = ForgeRegistries.ENTITY_TYPES.tags().createTagKey(new ResourceLocation("tanukidecor", "birdcage_blacklist"));
    private static final double CAGE_WIDTH = 0.75;
    private static final double CAGE_HEIGHT = 0.9375;
    private static final Predicate<LivingEntity> CAN_BE_CAGED = e -> !e.m_6095_().m_204039_(BIRDCAGE_BLACKLIST) && !(e instanceof Player) && !(e instanceof Monster) && e.m_6084_() && !((double)e.m_6095_().m_20680_().f_20377_ > 0.75) && !((double)e.m_6095_().m_20680_().f_20378_ > 0.9375);

    public BirdcageBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties, RotatingTallBlock.createShapeBuilder(SHAPE_UPPER, SHAPE_LOWER));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Override
    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            return COLLISION_SHAPE_UPPER;
        }
        return super.m_5939_(pState, pLevel, pPos, pContext);
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            this.getCagedEntity((Level)pLevel, pState, pPos).ifPresent(e -> this.updateEntityInCage((Entity)e));
        }
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            this.getCagedEntity(pLevel, pState, pPos).ifPresent(e -> this.extractCagedEntity((LivingEntity)e, pLevel, pState, pPos, null));
        }
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    @Override
    public void m_5707_(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (pState.m_61143_((Property)HALF) == DoubleBlockHalf.UPPER) {
            this.getCagedEntity(pLevel, pState, pPos).ifPresent(e -> this.extractCagedEntity((LivingEntity)e, pLevel, pState, pPos, pPlayer));
        }
        super.m_5707_(pLevel, pPos, pState, pPlayer);
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        Mob entity;
        BlockPos pos = this.getDelegatePos(pState, pPos);
        if (pEntity instanceof Mob && CAN_BE_CAGED.test((LivingEntity)(entity = (Mob)pEntity)) && this.getCagedEntity(pLevel, pState, pos).isEmpty() && !entity.m_20092_()) {
            Vec3 cagedPos = this.getCagedEntityPos(pLevel, pState, pos);
            entity.m_146884_(cagedPos);
            this.updateEntityInCage((Entity)entity);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        boolean hasShoulderEntity;
        if (pPlayer.m_6144_() || pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        BlockPos pos = this.getDelegatePos(pState, pPos);
        Vec3 cagePos = this.getCagedEntityPos(pLevel, pState, pos);
        Optional<LivingEntity> oEntity = this.getCagedEntity(pLevel, pState, pos);
        if (pLevel.m_5776_()) {
            return oEntity.isPresent() ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        if (oEntity.isPresent()) {
            this.extractCagedEntity(oEntity.get(), pLevel, pState, pos, pPlayer);
            return InteractionResult.SUCCESS;
        }
        boolean bl = hasShoulderEntity = !pPlayer.m_36331_().m_128456_() || !pPlayer.m_36332_().m_128456_();
        if (hasShoulderEntity) {
            if (this.spawnFromShoulderEntity(pPlayer, pPlayer.m_36331_(), cagePos).isPresent()) {
                pPlayer.m_36362_(new CompoundTag());
                return InteractionResult.SUCCESS;
            }
            if (this.spawnFromShoulderEntity(pPlayer, pPlayer.m_36332_(), cagePos).isPresent()) {
                pPlayer.m_36364_(new CompoundTag());
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockPathTypes getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return BlockPathTypes.BLOCKED;
    }

    private Optional<Entity> spawnFromShoulderEntity(Player player, CompoundTag compoundTag, Vec3 pos) {
        if (compoundTag.m_128456_()) {
            return Optional.empty();
        }
        Optional oEntity = EntityType.m_20642_((CompoundTag)compoundTag, (Level)player.m_9236_());
        oEntity.ifPresent(e -> {
            if (e instanceof TamableAnimal) {
                TamableAnimal tamable = (TamableAnimal)e;
                tamable.m_21816_(player.m_20148_());
            }
            e.m_6034_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            e.m_20256_(Vec3.f_82478_);
            ((ServerLevel)player.m_9236_()).m_8847_(e);
            this.updateEntityInCage((Entity)e);
        });
        return oEntity;
    }

    private void extractCagedEntity(LivingEntity entity, Level level, BlockState blockState, BlockPos pos, @Nullable Player player) {
        entity.m_20091_();
        if (entity instanceof ShoulderRidingEntity) {
            ShoulderRidingEntity ridingEntity = (ShoulderRidingEntity)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (ridingEntity.m_21830_((LivingEntity)player) && ridingEntity.m_29895_(serverPlayer)) {
                    return;
                }
            }
        }
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            tamable.m_21839_(false);
        }
        if (player != null) {
            entity.m_146884_(player.m_20182_());
        }
    }

    private void updateEntityInCage(Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tamable = (TamableAnimal)entity;
            tamable.m_21839_(true);
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.m_21573_().m_26573_();
            mob.m_6862_(false);
            mob.m_6710_(null);
        }
    }

    private Vec3 getCagedEntityPos(Level level, BlockState blockState, BlockPos blockPos) {
        return Vec3.m_82539_((Vec3i)this.getDelegatePos(blockState, blockPos)).m_82520_(0.0, 0.05, 0.0);
    }

    private Optional<LivingEntity> getCagedEntity(Level level, BlockState blockState, BlockPos pos) {
        Vec3 end;
        if (blockState.m_61143_((Property)HALF) != DoubleBlockHalf.UPPER) {
            return Optional.empty();
        }
        Vec3 start = Vec3.m_82528_((Vec3i)pos).m_82520_(0.1875, 0.0, 0.1875);
        AABB aabb = new AABB(start, end = start.m_82520_(0.625, 0.875, 0.625));
        List list = level.m_6443_(LivingEntity.class, aabb, CAN_BE_CAGED);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((LivingEntity)list.get(0));
    }
}

